<?php
/**
 * Template Name: Farmer Profile Data Page Template (Updated)
 * Description: Displays complete farmer job data using new farm_jobs table.
 */

get_header();
global $wpdb;

session_start(); // ✅ Ensure session is active

// ✅ Get farm job ID from URL ?id=1
$farm_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// ✅ Fetch farm job details
$farm = $wpdb->get_row(
    $wpdb->prepare("SELECT * FROM farm_jobs WHERE id = %d", $farm_id)
);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Farmer Profile</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      font-family: 'League Spartan', sans-serif;
      background-color: #f9f9f9;
    }
    .farmer-profile {
      max-width: 90%;
      margin: 50px auto;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      padding: 30px;
    }
    .farmer-profile h2 {
      color: #fc3c68;
      margin-bottom: 20px;
      font-weight: 700;
    }
    .profile-section {
      margin-bottom: 25px;
    }
    .profile-section h3 {
      border-bottom: 2px solid #fc3c68;
      padding-bottom: 5px;
      margin-bottom: 15px;
      color: #333;
      font-weight: 600;
    }
    .action-buttons {
      text-align: center;
      margin-top: 40px;
    }
    .action-buttons a {
      display: inline-block;
      margin: 0 10px;
      padding: 10px 25px;
      border-radius: 8px;
      background-color: #fc3c68;
      color: #fff;
      font-weight: 600;
      text-decoration: none;
      transition: 0.3s;
    }
    .action-buttons a:hover {
      background-color: #e22c55;
    }
    .btn-job{
        padding:10px 12px 10px 12px;
        background-color: #3173BD;
        font-family: "League Spartan", Sans-serif;
        font-weight: 600;
        color: white !important;
        text-decoration: none;
        font-size: 12px;
        border-radius:5px;
    }
    
    .btn-edit{
         
        background-color: #3173bd !important;
        font-family: "League Spartan", Sans-serif;
       
        color: white !important;
       
    }
    
    .profile-section p
     {
        margin-bottom: 5px;
        }
        
        .modal-footer {
            justify-content: flex-start !important;
        }
        
        .modal-body {
    max-height: 60vh; /* control height */
    overflow-y: auto; /* enable vertical scrolling */
}

    
    @media screen and (max-width: 600px) {
        .modal-content {
        margin-top: -80px;
      }
    }
  </style>
</head>

<body>
<div class="container farmer-profile">

  <?php if ($farm): ?>
    <h2>Farm Job Profile</h2>

    <!-- 🧍 Job Info -->
    <div class="profile-section">
      <h3>Job Information</h3>
      <p><strong>Role:</strong> <?php echo esc_html($farm->role); ?></p>
      <p><strong>Experience Required:</strong> <?php echo esc_html($farm->experience); ?></p>
      <p><strong>Salary Package:</strong> <?php echo esc_html($farm->salary_package); ?></p>
      <p><strong>Key Requirements:</strong><br> <?php echo nl2br(esc_html($farm->key_requirements)); ?></p>
    </div>

    <!-- 🐄 Farm Details -->
    <div class="profile-section">
      <h3>Farm Details</h3>
      <p><strong>Farm Name:</strong> <?php echo esc_html($farm->farm_name); ?></p>
      <p><strong>Total Animals:</strong> <?php echo esc_html($farm->total_animals); ?></p>
      <p><strong>Milking Cows:</strong> <?php echo esc_html($farm->milking_cows); ?></p>
      <p><strong>City:</strong> <?php echo esc_html($farm->city); ?></p>
      <p><strong>Address:</strong> <?php echo esc_html($farm->address); ?></p>
      <p><strong>About Farm:</strong><br> <?php echo nl2br(esc_html($farm->farm_about)); ?></p>
    </div>

    <!-- 🎁 Benefits -->
    <?php if (!empty($farm->benefits)): ?>
      <div class="profile-section">
        <h3>Farm Benefits</h3>
        <?php
          $benefit_items = preg_split("/[\r\n,]+/", trim($farm->benefits));
        ?>
        <ul>
          <?php foreach ($benefit_items as $benefit): ?>
            <li><?php echo esc_html(trim($benefit)); ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
      
      
    <?php endif; ?>

<!--<a href="#" class="btn-job" id="applyJobBtn" data-job-id="<?php echo $farm->id; ?>">Apply For Job</a>-->

<?php if (isset($_SESSION['user_id']) && isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'user'): ?>
    <a href="#" class="btn-job" id="applyJobBtn" data-job-id="<?php echo $farm->id; ?>">Apply For Job</a>
<?php endif; ?>


<!-- Apply Job Modal -->
<div class="modal fade" id="applyJobModal" tabindex="-1" aria-labelledby="applyJobLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="applyJobLabel">Apply For This Job</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body" id="userProfileData">
        <!-- Dynamic content will appear here -->
      </div>

      <div class="modal-footer">
        <!--<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>-->
        <button type="button" class="btn btn-primary" id="confirmApplyBtn" disabled>Submit Application</button>
      </div>
    </div>
  </div>
</div>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const applyBtn = document.getElementById("applyJobBtn");
    const modal = new bootstrap.Modal(document.getElementById("applyJobModal"));
    const userProfileData = document.getElementById("userProfileData");
    const confirmApplyBtn = document.getElementById("confirmApplyBtn");

    if (applyBtn) {
        applyBtn.addEventListener("click", function(e) {
            e.preventDefault();
            const jobId = this.getAttribute("data-job-id");

            // Fetch user data via AJAX
          fetch("<?php echo get_stylesheet_directory_uri(); ?>/page-templates/job-apply-submit.php?action=get_loggedin_user_profile&job_id=" + jobId)
                .then(res => res.text())
                .then(html => {
                    userProfileData.innerHTML = html;
                    confirmApplyBtn.disabled = !document.querySelector("#applyUserId");
                    modal.show();
                });
        });
    }

    // Handle submit application
    confirmApplyBtn.addEventListener("click", function() {
        const jobId = document.querySelector("#applyJobId")?.value;
        const userId = document.querySelector("#applyUserId")?.value;

        if (!userId) {
            alert("Please login first to apply for the job.");
            window.location.href = "https://rumicare.bibigadgets.com/user-login-form/";
            return;
        }

        fetch("<?php echo get_stylesheet_directory_uri(); ?>/page-templates/job-apply-submit.php?action=submit_job_application", {
                        method: "POST",
                        headers: {"Content-Type": "application/x-www-form-urlencoded"},
                        body: "user_id=" + userId + "&job_id=" + jobId
                    })

        .then(res => res.text())
        .then(response => {
            alert(response);
            modal.hide();
        });
    });
});
</script>

<?php 

if (isset($_GET['delete'])) {
    // Only allow if user is the owner
    if (isset($_SESSION['user_id']) && $_SESSION['user_id'] == $farm->farmer_id) {
        $wpdb->delete('farm_jobs', ['id' => $farm->id]);
        wp_redirect(home_url('/farm-dashboard/?deleted=success'));
        exit;
    } else {
        echo '<div class="alert alert-danger">❌ Unauthorized action!</div>';
    }
}
?>
   <?php 
// ✅ Show buttons only if a user is logged in AND owns this job post
if (
    isset($_SESSION['user_id'], $_SESSION['user_type']) &&
    $_SESSION['user_type'] === 'farm' &&
    $_SESSION['user_id'] == $farm->farmer_id
): ?>
    <div class="action-buttons">
        <a class="btn-edit" href="https://rumicare.bibigadgets.com/edit-farm-job/?id=<?php echo $farm->id; ?>">Edit</a>
       <a href="<?php echo home_url('/farmar-detail-page/?id=' . $farm->id . '&delete=1'); ?>" 
   onclick="return confirm('Are you sure you want to delete this job?');">
   Delete
</a>

    </div>
<?php endif; ?>


  <?php else: ?>
    <div class="alert alert-warning text-center">
      <strong>No job found!</strong> Please check your job ID.
    </div>
  <?php endif; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php get_footer('custom'); ?>
