<?php
/**
 * Template Name: User Profile Data Page Template
 * Description: Displays a complete user profile (public), edit/create button only for owner.
 */

get_header();
global $wpdb;

// Start session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Determine which profile to show
$profile_user_id = isset($_GET['id']) ? intval($_GET['id']) : (isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0);

if (!$profile_user_id) {
    echo "<p>No user specified.</p>";
    get_footer();
    exit;
}

// Fetch profile data (join user_profiles + user_info)
$profile = $wpdb->get_row($wpdb->prepare("
    SELECT p.*, u.username, u.email, u.contact
    FROM user_profiles p
    LEFT JOIN user_info u ON p.user_id = u.id
    WHERE p.user_id = %d
", $profile_user_id));

// Fetch education and experience
$education = $profile ? $wpdb->get_results($wpdb->prepare("SELECT * FROM user_education WHERE user_id = %d", $profile_user_id)) : [];
$experience = $profile ? $wpdb->get_results($wpdb->prepare("SELECT * FROM user_experience WHERE user_id = %d", $profile_user_id)) : [];

// Determine logged-in user
$logged_in_user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;

// Check if logged-in user has a profile
$logged_in_profile = $logged_in_user_id ? $wpdb->get_row($wpdb->prepare("SELECT * FROM user_profiles WHERE user_id = %d", $logged_in_user_id)) : null;
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>User Profile</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- jsPDF & html2canvas -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>


  <style>
    body {
      font-family: 'Red Hat Display', sans-serif;
      background-color: #f9f9f9;
    }

    .profile-container {
      max-width: 90%;
      margin: 50px auto;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      padding: 40px 20px;
    }

.alert.alert-warning.text-center.mt-5 h4 {
    font-size: 18px;
}
.alert.alert-warning.text-center.mt-5 {
    padding-bottom: 30px;
    padding-top: 30px;
}
    .profile-top {
      display: flex;
      align-items: center;
      gap: 20px;
      flex-wrap: nowrap;
    }

    .profile-image img {
      width: 120px;
      height: 120px;
      border-radius: 50%;
      border: 3px solid #fc3c68;
      background: white;
      object-fit: cover;
      object-position: center;
      flex-shrink: 0;
    }

    .user-info h2 {
      color: #fc3c68;
      font-weight: 700;
      margin-bottom: 10px;
    }

    .user-info p {
      margin-bottom: 6px;
      color: #444;
    }

    .user-info strong {
      color: #000;
    }

    h3.section-title {
      border-bottom: 2px solid #fc3c68;
      padding-bottom: 8px;
      margin-bottom: 15px;
      color: #333;
      font-weight: 600;
      font-size: 18px;
    }
    
    .mb-4 p {
        font-size: 13px;
    }
    
    .list-group-item{
        font-size: 13px;
    }

    .btn-edit-profile {
      background-color: #fc3c68;
      color: white !important;
      border: none;
      border-radius: 8px;
      font-weight: 600;
      padding: 10px 30px;
      text-decoration: none; 
      font-size: 13px;
}

    .btn-edit-profile:hover {
      background-color: #e7335d;
      color: white;
    }

        .text-danger {
            font-size: 18px;
        }
        
        .border.rounded.p-3.mb-3 p {
            font-size: 13px;
                margin: 4px;
        }
    @media (max-width: 576px) {
      .profile-top {
        flex-wrap: nowrap;
        align-items: flex-start;
      }
      .profile-image {
  width: 90px;
  height: 90px;
  border-radius: 50%;
  overflow: hidden;
  flex-shrink: 0;
  display: inline-block;
}

.profile-image img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 50%;
  display: block;
}

      .user-info h2 {
        font-size: 20px;
      }
      .user-info p {
        font-size: 13px;
        margin:0px;
      }
    button#download-cv {
    color: white !important;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    padding: 8px 30px;
    text-decoration: none;
    font-size: 13px;
}
    .text-center.mt-5.btn-style
         {
            display: flex;
            gap: 20px;
            justify-content: space-around;
        }
    
   }
   
   #download-cv{
color: white !important;
    background: #3173bd;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    padding: 10px 30px;
    text-decoration: none;
    font-size: 13px;
}
  </style>
</head>

<body>
<div class="container">
  <div class="profile-container">

    <?php if ($profile): ?>
      <!-- Profile Image + Info -->
      <div class="profile-top mb-4">
        <div class="profile-image">
          <?php
            $upload_dir = site_url('/wp-content/themes/onum/page-templates/uploads/');
            $image_path = !empty($profile->image) ? $upload_dir . $profile->image : $upload_dir . 'default.png';
          ?>
          <img src="<?php echo esc_url($image_path); ?>" alt="Profile Picture" crossOrigin="anonymous">
        </div>

        <div class="user-info">
          <h2><?php echo esc_html($profile->username); ?></h2>
          <p><strong>Email:</strong> <?php echo esc_html($profile->email); ?></p>
          <p><strong>Contact:</strong> <?php echo esc_html($profile->contact); ?></p>
          <p><strong>City:</strong> <?php echo esc_html($profile->city); ?></p>
          <p><strong>Birthdate:</strong> <?php echo esc_html($profile->birthdate); ?></p>
        </div>
      </div>

      <div class="mb-4">
        <h3 class="section-title">Bio</h3>
        <p><?php echo nl2br(esc_html($profile->bio)); ?></p>
      </div>
      
      
      <?php if ($education): ?>
        <div class="mb-4">
          <h3 class="section-title">Education</h3>
          <ul class="list-group">
            <?php foreach ($education as $edu): ?>
              <li class="list-group-item">
                <strong><?php echo esc_html($edu->course); ?></strong> -
                <?php echo esc_html($edu->institute); ?> (<?php echo esc_html($edu->completion_date); ?>)
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <div class="mb-4">
        <h3 class="section-title">Skills</h3>
            <p>
            <?php
            $skills = explode(',', $profile->skills);
            foreach ($skills as $skill) {
                echo esc_html(trim($skill)) . ",<br>";
            }
            ?>
            </p>

      </div>

      

      <?php if ($experience): ?>
        <div class="mb-4">
          <h3 class="section-title">Experience</h3>
          <?php foreach ($experience as $exp): ?>
            <div class="border rounded p-3 mb-3">
              <h5 class="text-danger mb-1"><?php echo esc_html($exp->job_designation); ?></h5>
              <p><strong>Company:</strong> <?php echo esc_html($exp->company_name); ?></p>
              <p><strong>Period:</strong> <?php echo esc_html($exp->start_date); ?> - <?php echo esc_html($exp->end_date ?: 'Present'); ?></p>
              <p><strong>Responsibilities:</strong><br><?php echo nl2br(esc_html($exp->work_responsibilities)); ?></p>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>

      <!-- Edit/Create button only for logged-in user viewing own profile -->
      <?php if ($logged_in_user_id && $logged_in_user_id === $profile_user_id): ?>
        <div class="text-center mt-5 btn-style">
          <?php if ($logged_in_profile): ?>
            <a href="<?php echo esc_url(site_url('/user-profile-edit/?id=' . $logged_in_user_id)); ?>" class="btn-edit-profile">Edit Profile</a>
            <!--<button id="download-cv" class="btn btn-primary">Download CV</button>-->

<a id="download-cv" href="<?php echo esc_url(site_url('/profile-download-cv/?id=' . $logged_in_user_id)); ?>">
    Download CV
</a>
          <?php endif; ?>
        </div>
      <?php endif; ?>

    <?php else: ?>
      <div class="alert alert-warning text-center mt-5">
        <h4>No Profile Found</h4>
        <p>This user has not created a profile yet.</p>
                    <a href="https://rumicare.bibigadgets.com/registration-page/" class="btn-edit-profile">Create Profile</a>

        <a></a>
      </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>


<?php get_footer(); ?>
