<?php
/**
 * Handles profile update requests (called from edit-user-profile.php)
 */

require_once('../../../../wp-load.php'); // Adjust if needed
global $wpdb;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    wp_die('Invalid request.');
}

$user_id = intval($_POST['user_id']);
if ($user_id <= 0) {
    wp_die('Invalid user ID.');
}

// === Setup Upload Directory ===
$upload_dir = get_template_directory() . '/page-templates/uploads/';
$upload_url = get_template_directory_uri() . '/page-templates/uploads/';


if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// === Handle Image Upload ===
$image_url = '';
$old_image = $wpdb->get_var($wpdb->prepare(
    "SELECT image FROM user_profiles WHERE user_id = %d",
    $user_id
));

if (!empty($_FILES['image']['name'])) {
    // Remove old file
    if (!empty($old_image)) {
        $old_path = $upload_dir . basename($old_image);
        if (file_exists($old_path)) {
            unlink($old_path);
        }
    }

    $image_name = time() . "_" . basename($_FILES["image"]["name"]);
    $target_file = $upload_dir . $image_name;

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_url = $image_name;
    } else {
        wp_die("Error uploading image.");
    }
} else {
    $image_url = $old_image ? $old_image : '';
}

// === Sanitize Inputs ===
$username   = sanitize_text_field($_POST['username']);
$email      = sanitize_email($_POST['email']);
$password   = isset($_POST['password']) ? trim($_POST['password']) : '';
$contact    = sanitize_text_field($_POST['contact']);
$birthdate  = sanitize_text_field($_POST['birthdate']);
$city       = sanitize_text_field($_POST['city']);
$bio        = sanitize_textarea_field($_POST['bio']);
$skills     = isset($_POST['skills']) ? implode(',', array_map('sanitize_text_field', $_POST['skills'])) : "";

// =======================================================
// 1️⃣ UPDATE user_info (basic account data)
// =======================================================
$user_info_data = [
    'username' => $username,
    'email'    => $email,
    'contact'  => $contact
];

if (!empty($password)) {
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $user_info_data['password'] = $hashed_password;
}

$wpdb->update(
    'user_info',
    $user_info_data,
    ['id' => $user_id]
);

// =======================================================
// 2️⃣ UPDATE user_profiles (extended data)
// =======================================================
$profile_data = [
    'birthdate' => $birthdate,
    'city'      => $city,
    'bio'       => $bio,
    'skills'    => $skills,
    'image'     => $image_url,
];

$wpdb->update(
    'user_profiles',
    $profile_data,
    ['user_id' => $user_id]
);

// =======================================================
// 3️⃣ UPDATE EDUCATION
// =======================================================
$wpdb->delete('user_education', ['user_id' => $user_id]);

if (!empty($_POST['course'])) {
    foreach ($_POST['course'] as $i => $course) {
        $institute = sanitize_text_field($_POST['institute'][$i]);
        $year = sanitize_text_field($_POST['year'][$i]);
        if (!empty($course) && !empty($institute)) {
            $wpdb->insert('user_education', [
                'user_id' => $user_id,
                'course' => $course,
                'institute' => $institute,
                'completion_date' => $year
            ]);
        }
    }
}

// =======================================================
// 4️⃣ UPDATE EXPERIENCE
// =======================================================
$wpdb->delete('user_experience', ['user_id' => $user_id]);

if (!empty($_POST['company_name'])) {
    foreach ($_POST['company_name'] as $i => $company_name) {
        $job_designation = sanitize_text_field($_POST['job_designation'][$i]);
        $start_date = sanitize_text_field($_POST['start_date'][$i]);
        $end_date = sanitize_text_field($_POST['end_date'][$i]);
        $responsibilities = sanitize_textarea_field($_POST['work_responsibilities'][$i]);
        if (!empty($company_name) && !empty($job_designation)) {
            $wpdb->insert('user_experience', [
                'user_id' => $user_id,
                'company_name' => $company_name,
                'job_designation' => $job_designation,
                'start_date' => $start_date,
                'end_date' => $end_date,
                'work_responsibilities' => $responsibilities
            ]);
        }
    }
}

// =======================================================
// ✅ REDIRECT WITH SUCCESS MESSAGE
// =======================================================
echo "<script>alert('Profile updated successfully!'); window.location.href='" . esc_url(site_url('/user-detail-page/?id=' . $user_id)) . "';</script>";
exit;

?>
