<?php
/**
 * Template Name: Super Admin View User
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

$user_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$user_info = $wpdb->get_row("SELECT * FROM user_info WHERE id = $user_id");
$user_profile = $wpdb->get_row("SELECT * FROM user_profiles WHERE user_id = $user_id");
$user_education = $wpdb->get_results("SELECT * FROM user_education WHERE user_id = $user_id");
$user_experience = $wpdb->get_results("SELECT * FROM user_experience WHERE user_id = $user_id");

$applied_jobs = $wpdb->get_results("
    SELECT j.id AS application_id, j.applied_on, f.id AS job_id, f.role, f.farm_name, f.city, f.salary_package
    FROM job_applications j
    INNER JOIN farm_jobs f ON j.job_id = f.id
    WHERE j.user_id = $user_id
    ORDER BY j.id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>Super Admin | View User</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
    background: #f1f3f8;
    font-family: "Poppins", Arial, sans-serif;
    margin: 0;
    padding: 0;
    color: #333;
}

.container {
    max-width: 1200px;
    margin: 40px auto;
    padding: 0 20px;
}

.card {
    background: #fff;
    border-radius: 14px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    padding: 25px 30px;
    margin-bottom: 25px;
    transition: 0.3s;
}

.card:hover {
    box-shadow: 0 6px 20px rgba(0,0,0,0.12);
}

.header {
    display: flex;
    align-items: center;
    border-bottom: 2px solid #eaeaea;
    padding-bottom: 20px;
    margin-bottom: 25px;
}

.header img {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    object-fit: cover;
    margin-right: 25px;
    border: 3px solid #0073aa;
}

.header h2 {
    margin: 0;
    color: #0073aa;
    font-size: 24px;
}

.header p {
    margin: 5px 0;
    color: #555;
}

.section-title {
    font-size: 18px;
    color: #0073aa;
    font-weight: 600;
    margin-bottom: 15px;
    border-left: 5px solid #0073aa;
    padding-left: 10px;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 15px;
}

.info-item {
    background: #f8fafc;
    padding: 12px 15px;
    border-radius: 8px;
    border: 1px solid #e0e0e0;
}

.info-item strong {
    display: block;
    color: #444;
    font-weight: 600;
    margin-bottom: 5px;
}

.table-wrapper {
    overflow-x: auto;
}

table {
    width: 100%;
    border-collapse: collapse;
    border-radius: 10px;
    overflow: hidden;
}

table th, table td {
    padding: 12px 15px;
    border-bottom: 1px solid #e5e5e5;
    text-align: left;
    font-size: 15px;
}

table th {
    background: #0073aa;
    color: #fff;
    font-weight: 600;
}

table tr:hover {
    background-color: #f9fafc;
}

.no-data {
    color: #888;
    font-style: italic;
    padding: 10px;
}

.back-btn {
    display: inline-block;
    background: #0073aa;
    color: #fff;
    padding: 10px 18px;
    border-radius: 6px;
    text-decoration: none;
    margin-bottom: 20px;
    transition: 0.3s;
}

.back-btn:hover {
    background: #005f8d;
}

/* Action Buttons */
.action-btn {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 5px;
    text-decoration: none;
    color: #fff;
    font-size: 13px;
    margin-right: 6px;
    transition: 0.3s;
}

.action-btn.view {
    background: #28a745;
}

.action-btn.view:hover {
    background: #218838;
}

.action-btn.delete {
    background: #dc3545;
}

.action-btn.delete:hover {
    background: #b52a35;
}
</style>
</head>
<body>

<div class="container">
    <a href="<?= site_url('/super-admin') ?>" class="back-btn">← Back to Dashboard</a>

    <?php if ($user_info): ?>
    <div class="card header">
        <img src="https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/uploads/<?= ($user_profile->image ?? 'https://via.placeholder.com/100'); ?>" alt="User Image">
        <div>
            <h2><?= esc_html($user_info->username); ?></h2>
            <p><strong>Email:</strong> <?= esc_html($user_info->email); ?></p>
            <p><strong>Contact:</strong> <?= esc_html($user_info->contact); ?></p>
        </div>
    </div>

    <!-- Profile -->
    <div class="card">
        <h3 class="section-title">Profile Details</h3>
        <?php if ($user_profile): ?>
        <div class="info-grid">
            <div class="info-item"><strong>City</strong><?= esc_html($user_profile->city); ?></div>
            <div class="info-item"><strong>Birthdate</strong><?= esc_html($user_profile->birthdate); ?></div>
            <div class="info-item"><strong>Bio</strong><?= esc_html($user_profile->bio); ?></div>
            <div class="info-item"><strong>Skills</strong><?= esc_html($user_profile->skills); ?></div>
        </div>
        <?php else: ?><p class="no-data">No profile found.</p><?php endif; ?>
    </div>

    <!-- Education -->
    <div class="card">
        <h3 class="section-title">Education</h3>
        <?php if ($user_education): ?>
        <div class="table-wrapper">
            <table>
                <tr><th>Course</th><th>Institute</th><th>Completion Date</th></tr>
                <?php foreach ($user_education as $edu): ?>
                <tr>
                    <td><?= esc_html($edu->course); ?></td>
                    <td><?= esc_html($edu->institute); ?></td>
                    <td><?= esc_html($edu->completion_date); ?></td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <?php else: ?><p class="no-data">No education records found.</p><?php endif; ?>
    </div>

    <!-- Experience -->
    <div class="card">
        <h3 class="section-title">Experience</h3>
        <?php if ($user_experience): ?>
        <div class="table-wrapper">
            <table>
                <tr><th>Company</th><th>Designation</th><th>Period</th><th>Responsibilities</th></tr>
                <?php foreach ($user_experience as $exp): ?>
                <tr>
                    <td><?= esc_html($exp->company_name); ?></td>
                    <td><?= esc_html($exp->job_designation); ?></td>
                    <td><?= esc_html($exp->start_date . ' → ' . $exp->end_date); ?></td>
                    <td><?= esc_html($exp->work_responsibilities); ?></td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <?php else: ?><p class="no-data">No experience records found.</p><?php endif; ?>
    </div>

    <!-- Jobs Applied -->
    <div class="card">
        <h3 class="section-title">Jobs Applied</h3>
        <?php if ($applied_jobs): ?>
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>Role</th>
                    <th>Farm Name</th>
                    <th>City</th>
                    <th>Salary</th>
                    <th>Applied On</th>
                    <th>Actions</th>
                </tr>
                <?php foreach ($applied_jobs as $job): ?>
                <tr>
                    <td><?= esc_html($job->role); ?></td>
                    <td><?= esc_html($job->farm_name); ?></td>
                    <td><?= esc_html($job->city); ?></td>
                    <td><?= esc_html($job->salary_package); ?></td>
                    <td><?= esc_html($job->applied_on); ?></td>
                    <td>
                        <a href="<?= site_url('/super-admin-view-job?id=' . $job->job_id); ?>" class="action-btn view">View</a>
                        <a href="#" class="action-btn delete" onclick="return confirm('Are you sure you want to delete this application?');">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <?php else: ?><p class="no-data">No jobs found.</p><?php endif; ?>
    </div>

    <?php else: ?>
        <p class="no-data">User not found.</p>
    <?php endif; ?>
</div>

</body>
</html>
