<?php
/**
 * Template Name: Super Admin Login
 * Description: Login page for Super Admin users.
 */

get_header();
global $wpdb;

session_start(); // Start PHP session

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $login_input = sanitize_text_field($_POST['login']); 
    $password    = $_POST['password'];

    // Detect if input is email or username
    if (filter_var($login_input, FILTER_VALIDATE_EMAIL)) {
        // If input is email
        $admin = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM super_admin WHERE email = %s LIMIT 1",
                $login_input
            )
        );
    } else {
        // If input is username
        $admin = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM super_admin WHERE username = %s LIMIT 1",
                $login_input
            )
        );
    }

    if ($admin) {

        if (password_verify($password, $admin->password)) {

            session_regenerate_id(true);

            $_SESSION['super_admin_id']    = $admin->id;
            $_SESSION['super_admin_name']  = $admin->username;
            $_SESSION['super_admin_email'] = $admin->email;

            wp_safe_redirect(home_url("/super-admin-dashboard/"));
            exit;

        } else {
            $message = '<div class="alert alert-danger mt-3">❌ Incorrect password.</div>';
        }

    } else {
        $message = '<div class="alert alert-danger mt-3">❌ Email or Username not found.</div>';
    }
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Super Admin Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
body { background-color: #f7f7f7; font-family: "League Spartan", sans-serif; }
.login-container { max-width: 420px; margin: 80px auto; background: #fff; padding: 35px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
.btn-login { background-color: #fc3c68; color: #fff; font-weight: 600; border-radius: 8px; transition: all 0.3s ease; }
.btn-login:hover { background-color: #e1325c; transform: translateY(-2px); }

.login-container h2{
    font-size:20px ;
}
input, select,textarea, button, label {
    font-size: 16px !important;
  }
  
@media screen and (max-width: 600px) {
 .login-container { max-width: 90%; }
}
</style>
</head>
<body>

<div class="login-container">
  <h2 class="text-center mb-4">Super Admin Login</h2>

  <?php echo $message; ?>

  <form method="post" action="">
    <div class="mb-3">
      <label class="form-label">Email</label>
      <input type="text" name="login" class="form-control" placeholder="Enter your email" required>
    </div>

    <div class="mb-3 position-relative">
      <label class="form-label">Password</label>
      <div class="input-group">
        <input type="password" name="password" id="passwordField" class="form-control" placeholder="Enter your password" required>
        <button type="button" class="btn btn-outline-secondary" id="togglePassword" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
          <i class="fa-solid fa-eye" id="eyeIcon"></i>
        </button>
      </div>
    </div>

    <div class="d-grid">
      <button type="submit" class="btn btn-login py-2">Login</button>
    </div>
  </form>

  <!--<div class="text-end mt-2">-->
  <!--  <a href="https://rumicare.bibigadgets.com/forgot-password/" class="text-decoration-none">Forgot Password?</a>-->
  <!--</div>-->
</div>

</body>
</html>

<?php get_footer('custom'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const passwordField = document.getElementById('passwordField');
  const togglePassword = document.getElementById('togglePassword');
  const eyeIcon = document.getElementById('eyeIcon');

  togglePassword.addEventListener('click', function() {
    const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
    passwordField.setAttribute('type', type);
    eyeIcon.classList.toggle('fa-eye');
    eyeIcon.classList.toggle('fa-eye-slash');
  });
});
</script>
