<?php 
/**
 * Template Name: Rumi Trainings
 */
get_header();
?>
<style>
    .banner-img{
        margin:auto;
        text-align:center;
    }
</style>

<div class="banner-img">
    <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/45etdfxr5.png">

</div>
<div class="container-fluid rumi-trainings">
  <!--<h1>Hello World!</h1>-->
  <!--<p>Resize the browser window to see the effect.</p>-->


    <!-- On Farm Tranning Section-->
 <div class="training-box d-flex flex-wrap align-items-center">
    <div class="training-img">
      <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/11/wsfd-1.png" alt="On-Farm Training">
    </div>

    <div class="training-content">
      <h4>On-Farm Training</h4>
      <p>Hands-on training directly at your dairy farm with our experts guiding farmers and staff.</p>
    </div>

    <div class="training-details w-100">
      <ul>
        <li>Practical learning on your farm</li>
        <li>Immediate solutions for your herd & facilities</li>
        <li>Tailored advice for your farm’s needs</li>
      </ul>
        <a href="https://rumicare.bibigadgets.com/on-farm-traning/" class="btn btn-primary">Apply Now</a>
    </div>
  </div>
  
      <!-- Group Tranning Section-->
    <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-img">
          <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/11/wsfd-2.png" alt="On-Farm Training">
        </div>
    
        <div class="training-content">
          <h4>Group Training</h4>
          <p>Interactive traning sessions with multiple farmers and staff together.</p>
        </div>
    
        <div class="training-details w-100">
          <ul>
            <li>Learn from experts and fellow farmers</li>
            <li>Cost-effective and knowledge sharing environment</li>
            <li>Certification after completion</li>
          </ul>
              <a href="https://rumicare.bibigadgets.com/group-farm-traning/" class="btn btn-primary">Apply Now</a>
        </div>
      </div>
      
      
        <!-- Group Tranning Section-->
    <div class="training-box d-flex flex-wrap align-items-center">
        <div class="training-img">
          <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/3erfdxc.png" alt="On-Farm Training">
        </div>
    
        <div class="training-content">
          <h4>Online Training</h4>
          <p>Flexible learning from home with expert video sessions and practical demonstrations.</p>
        </div>
    
        <div class="training-details w-100">
          <ul>
            <li>Learn from anywhere, anytime</li>
            <li>Access recorded sessions for revision</li>
            <li>Cost-effective and convenient training</li>
          </ul>
              <a href="https://rumicare.bibigadgets.com/online-farm-traning/" class="btn btn-primary">Apply Now</a>
        </div>
      </div>
  
  
  
</div>

<style>/* ===============================
   Rumi Trainings Page Styling
================================= */

.rumi-trainings {
  width: 90%;
  margin: auto;
  padding: 20px 0;
}

.training-box {
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  align-items: flex-start;
  background-color: white;
  box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 4px;
  border-radius: 8px;
  padding: 15px;
  margin-bottom: 20px;
  gap: 15px;
}

/* Left image */
.training-img {
  flex: 0 0 80px;
}

.training-img img {
  width: 80px;
  height: 80px;
  border-radius: 8px;
  object-fit: cover;
}

/* Right text */
.training-content {
  flex: 1;
}

.training-content h4 {
  margin: 0 0 5px;
  font-weight: 600;
  font-family: "League Spartan", Sans-serif;
      font-size: 16px;
    
}

div, h1, h2, h3, h4, h5, h6, p, span, ul, li, a {
    font-family: "League Spartan", Sans-serif;
}
.training-content p {
  margin: 0;
  color: #333;
  font-size: 13px;
  line-height: 15px;
    font-family: "League Spartan", Sans-serif;
}

/* Details below both */
.training-details {
  width: 100%;
  margin-top: 15px;
}

/*.training-details ul {*/
/*  margin-left: 20px;*/
/*  margin-bottom: 10px;*/
/*}*/

.training-details a.btn {
  background-color: #007bff;
  color: #fff;
  border: none;
    font-family: "League Spartan", Sans-serif;
}

/* ✅ Custom tick list style */
.training-details ul {
  list-style: none;
  padding: 0;
  margin: 0 0 10px 0;
    font-family: "League Spartan", Sans-serif;
}

.training-details li {
      font-family: "League Spartan", Sans-serif;
  position: relative;
  padding-left: 35px;
  margin-bottom: 0px;
  font-size: 15px;
  color: #333;
}

/* Green circle + tick before each item */
.training-details li::before {
  content: "✔";
  position: absolute;
  left: 0;
  top: 50%;
  transform: translateY(-50%);
  background-color: #28a745; /* Green background */
  color: #fff;               /* White tick */
  font-weight: bold;
  font-size: 12px;
  border-radius: 50%;
  width: 20px;
  height: 20px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.training-details a.btn {
    display: flex;
    justify-content: space-around;
    text-align: center !important;
    width: 35%;
    margin-left: auto;
    padding: 5px 15px 5px 12px;
    font-size: 13px;
}
}

/* Responsive tweaks */
@media (max-width: 600px) {
  .training-img {
    flex: 0 0 60px;
  }

  .training-img img {
    width: 60px;
    height: 60px;
  }

}
</style>

<?php get_footer(); ?>
