<?php
/**
 * Template Name: Reset Password Template
 * Description: Allows users or farmers to set a new password using token.
 */

get_header();
global $wpdb;

$message = '';
$token = $_GET['token'] ?? '';
$type  = $_GET['type'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = sanitize_text_field($_POST['token']);
    $type  = sanitize_text_field($_POST['type']);
    $new_pass = $_POST['new_password'];

    $table = ($type === 'farm') ? 'farmars_info' : 'user_info';
    $user = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE reset_token = %s LIMIT 1", $token));

    if ($user) {
        $hashed = password_hash($new_pass, PASSWORD_DEFAULT);
        $wpdb->update(
            $table,
            ['password' => $hashed, 'reset_token' => ''],
            ['id' => $user->id]
        );
        $message = '<div class="alert alert-success mt-3">✅ Password reset successfully. <a href="/user-login-form/">Login now</a>.</div>';
    } else {
        $message = '<div class="alert alert-danger mt-3">❌ Invalid or expired reset link.</div>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Reset Password</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
body { background-color: #f7f7f7; font-family: "League Spartan", sans-serif; }
.login-container { max-width: 420px; margin: 80px auto; background: #fff; padding: 35px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
.btn-login { background-color: #fc3c68; color: #fff; font-weight: 600; border-radius: 8px; transition: all 0.3s ease; }
.btn-login:hover { background-color: #e1325c; transform: translateY(-2px); }
    
    @media screen and (max-width: 600px) {
     .login-container { max-width: 90%;}
    }
    
</style>
</head>
<body>

<div class="login-container">
  <h2 class="text-center mb-4">Reset Password</h2>
  <?php echo $message; ?>
  <?php if ($token && !$message): ?>
  <form method="post" action="">
    <input type="hidden" name="token" value="<?php echo esc_attr($token); ?>">
    <input type="hidden" name="type" value="<?php echo esc_attr($type); ?>">
    <div class="mb-3">
      <label class="form-label">New Password</label>
      <div class="input-group">
        <input type="password" name="new_password" id="passwordField" class="form-control" placeholder="Enter your new password" required>
        <button type="button" class="btn btn-outline-secondary" id="togglePassword" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
          <i class="fa-solid fa-eye" id="eyeIcon"></i>
        </button>
      </div>
    </div>
    <div class="d-grid">
      <button type="submit" class="btn btn-login py-2">Update Password</button>
    </div>
  </form>
  <?php endif; ?>

  <div class="text-center mt-4">
    <a href="https://rumicare.bibigadgets.com/user-login-form/" class="btn btn-outline-primary">Back to Login</a>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const passwordField = document.getElementById('passwordField');
  const togglePassword = document.getElementById('togglePassword');
  const eyeIcon = document.getElementById('eyeIcon');

  togglePassword.addEventListener('click', function() {
    const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
    passwordField.setAttribute('type', type);
    eyeIcon.classList.toggle('fa-eye');
    eyeIcon.classList.toggle('fa-eye-slash');
  });
});
</script>

<?php get_footer('custom'); ?>
</body>
</html>
