<?php
session_start(); // Ensure session is started
global $wpdb;

// Check if user is logged in
if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
    $user_id = intval($_SESSION['user_id']);

    // Check if user already has profile data in the `user_profiles` table
    $profile_exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM user_profiles WHERE user_id = %d",
        $user_id
    ));

    if ($profile_exists > 0) {
        echo "<script>
                alert('You have already a profile.');
                window.location.href = '" . esc_url("https://rumicare.bibigadgets.com/user-detail-page/?id=" . $user_id) . "';
              </script>";
    } else {
        // User does not have profile, redirect back to homepage
      
    }
} else {
    // Not logged in, redirect to homepage or login page
    echo "<script>
            alert('You must be logged in to access this page.');
            window.location.href = '" . esc_url(home_url('/')) . "';
          </script>";
    exit;
}
?>




<?php
session_start();

global $wpdb;

// Initialize default empty values
$username = $email = $contact = '';

if (isset($_SESSION['user_id'])) {
    $user_id = intval($_SESSION['user_id']);

    // Fetch user data from user_info
    $user_info = $wpdb->get_row($wpdb->prepare(
    "SELECT username, email, contact, created_at FROM user_info WHERE id = %d",
        $user_id
    ));

    if ($user_info) {
        $username = esc_attr($user_info->username);
        $email = esc_attr($user_info->email);
        $contact = esc_attr($user_info->contact);
          $created_at = $user_info->created_at ? date('d M Y', strtotime($user_info->created_at)) : 'N/A';
    }
}
?>

<?php
/**
 * Template Name: User-registration Form Page Template
 * Description: A Page Template with a design.
 */
get_header();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Professional User Registration Form</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap 5 CSS & JS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>



<style>
body { background-color: #f8f9fa; font-family: "League Spartan", Sans-serif;}
.form-section { background:#fff; padding:25px; border-radius:12px; box-shadow:0 0 10px rgba(0,0,0,0.05); margin:15px; }
.form-control { border-radius:3px !important; }
.form-heading { font-weight:bold; font-size:18px; margin-bottom:20px; border-bottom:2px solid #dee2e6; padding-bottom:5px; color:red; }
.form-headingg { font-weight:bold; font-size:18px; color:red; }
.remove-btn { background-color:#dc3545; color:white; line-height:12px;padding-bottom: 2px;}
.add-btn { background-color:#198754; color:white; }
.main-sec { width:90%; margin:auto; padding:20px 15px 0 15px; }
.text-endd { width:90%; margin:auto; }
.text-endd button { width:100%; font-size:14px; padding-top:6px; }
.info-label { font-weight: 600; color: #333; font-size: 14px; margin-right: 10px; }
.info-value { font-weight: 400; color: #000; font-size: 14px; }

.col-md-6 span {
    font-size: 16px;
}
  input,textarea,select{
        padding: 10px 10px !important;
         font-size: 16px !important;
    }
    label{
        font-size: 15px;
    }
    .form-check .form-check-input {
    margin-right: 5px;
    padding: 5px !important;
}
span.head-text {
    font-size: 18px;
}

 .crop-modal {
    display: none;
    position: fixed;
    top: 0; 
    left: 0;
    width: 100%; 
    height: 100%;
    background: rgba(0,0,0,0.7);
    justify-content: center;
    align-items: center;
    z-index: 99999;
    padding: 20px;
    box-sizing: border-box;
}

.crop-container {
    background: #fff;
    padding: 15px;
    border-radius: 12px;
    max-width: 90vw;      /* Limit popup width */
    max-height: 90vh;     /* Limit popup height */
    overflow: hidden;     /* Prevent image from overflowing */
    box-sizing: border-box;
}

.crop-container img {
    max-width: 100%;
    max-height: 70vh;     /* Image will never exceed screen height */
    width: auto;
    height: auto;
    display: block;
    margin: 0 auto;
}
.crop-close {
    position: absolute;
    top: 15px;
    right: 20px;
    font-size: 28px;
    font-weight: bold;
    color: #333;
    cursor: pointer;
    z-index: 999999;
    transition: 0.2s;
}

.crop-close:hover {
    color: #fc3c68;
}
.form-profile{
    margin-top:20px;
}
input#imageInput {
    padding: 4px !important;
}

</style>


</head>
<body>

<!-- Header Section -->
<div class="main-sec">
<div class="d-flex justify-content-between align-items-center">
  <div>
    <span class="head-text">Create a job seeker profile</span><br>
    <!--<span class="head-para">Personal information</span>-->
  </div>
  <div>
    <img src="<?php echo get_template_directory_uri(); ?>/page-templates/3wsz.svg" alt="Icon">
  </div>
</div>
</div>

<div class="container my-5">
<form action="<?php echo esc_url(get_template_directory_uri() . '/page-templates/registration-submit.php'); ?>" method="POST" enctype="multipart/form-data">

 <div class="form-section">
    <div class="form-heading">Personal Information</div>
    <div class="row">
        
          <div class="col-md-6">
          <span class="info-label">Full Name:</span>
          <span class="info-value"><?php echo $username; ?></span>
        </div>
        
         <div class="col-md-6">
          <span class="info-label">Email:</span>
          <span class="info-value"><?php echo $email; ?></span>
        </div>
        
         <div class="col-md-6">
          <span class="info-label">WhatsApp No:</span>
          <span class="info-value"><?php echo $contact; ?></span>
        </div>
        
        <div class="col-md-6">
            <span class="info-label">Created At:</span>
            <span class="info-value"><?php echo $created_at; ?></span>
        </div>
        
        </div>
    </div>


  <!-- Personal Info -->
  <div class="form-section">
    <div class="form-heading">Complete Profile</div>
    <div class="row">
      <div class="col-md-6 mb-3">
        <label class="form-label">Birth Date</label>
        <input type="date" name="birthdate" class="form-control" required>
      </div>

      <div class="col-md-6 mb-3">
        <label class="form-label">City</label>
        <input type="text" name="city" class="form-control" required>
      </div>

      <div class="col-12 mb-3">
        <label class="form-label">Description</label>
        <textarea name="bio" class="form-control" rows="4" placeholder="Write a short biography..." required></textarea>
      </div>

      <div class="col-12 mb-3">
        <label class="form-label">Extra Skills</label>
        <select name="skills[]" class="form-control" multiple required>
          <option value="">-- Select Extra Skill --</option>
          <option value="Feed Formulation">Feed Formulation</option>
          <option value="Hoof Trimming">Hoof Trimming</option>
          <option value="Artificial Insemination">Artificial Insemination</option>
          <option value="Pregnancy Diagnosis">Pregnancy Diagnosis</option>
          <option value="Minor Surgery">Surgeries - Minor</option>
          <option value="Major Surgery">Surgeries - Major</option>
          <option value="Working on Excel Sheet">Working on Excel Sheet</option>
          <option value="Record Keeping on Software">Record Keeping on Software</option>
          <option value="Calf Care">Calf Care</option>
          <option value="Milking Parlor Handling">Milking Parlor Handling</option>
        </select>
      </div>

    
    
    <div class="form-profile">
    <h5 class="form-heading">Profile Picture</h5>

    <div class="profile-preview mb-3">
        <img id="profilePreview" 
             src="<?php echo $profile->image ? $upload_url . $profile->image : 'https://rumicare.bibigadgets.com/wp-content/uploads/2025/10/2ewdszx.png'; ?>" 
             style="width:150px; border-radius:5px;">
    </div>

    <input type="file" name="image" id="imageInput" accept="image/*" class="form-control">

    <!-- Popup Modal for cropping -->
    <div id="cropModal" class="crop-modal">
        <div class="crop-container position-relative">
            <span class="crop-close">&times;</span>

            <img id="cropImage">

            <button id="cropButton" class="btn btn-success w-100 mt-3">
                Crop & Upload
            </button>
        </div>
    </div>
</div>



      
    </div>
  </div>

  <!-- Education Records -->
  <div class="form-section">
    <div class="form-heading d-flex justify-content-between align-items-center">
      <span class="form-headingg">Education Records</span>
      <button type="button" class="btn add-btn btn-sm" onclick="addEducation()">+ Add Education</button>
    </div>
    <div id="education-container"></div>
  </div>

  <!-- Work Experience -->
  <div class="form-section">
    <div class="form-heading d-flex justify-content-between align-items-center">
      <span class="form-headingg">Work Experience</span>
      <button type="button" class="btn add-btn btn-sm" onclick="addWorkExperience()">+ Add Experience</button>
    </div>
    <div id="work-experience-container"></div>
  </div>

  <!-- Submit Button -->
  <div class="text-endd">
    <button type="submit" class="btn btn-primary px-4">Submit</button>
  </div>

</form>
</div>

<!-- JS Scripts -->
<script>
// Education
function addEducation() {
  const container = document.getElementById('education-container');
  const wrapper = document.createElement('div');
  wrapper.classList.add('border','rounded','p-3','mb-3','bg-light','position-relative');
  wrapper.innerHTML = `
    <div class="row align-items-end">
      <div class="col-md-4 mb-3">
        <label class="form-label">Diploma/Degree</label>
        <input type="text" name="course[]" class="form-control" placeholder="e.g. BSc Computer Science" required>
      </div>
      <div class="col-md-4 mb-3">
        <label class="form-label">Institute</label>
        <input type="text" name="institute[]" class="form-control" placeholder="e.g. Harvard University" required>
      </div>
      <div class="col-md-3 mb-3">
        <label class="form-label">Completion Date</label>
        <input type="date" name="year[]" class="form-control" required>
      </div>
      <div class="col-md-1 mb-3 text-end">
        <button type="button" class="btn remove-btn" onclick="removeEducation(this)">×</button>
      </div>
    </div>`;
  container.appendChild(wrapper);
}
function removeEducation(btn){ btn.closest('.border').remove(); }
window.onload = addEducation;

// Work Experience
function addWorkExperience() {
  const container = document.getElementById('work-experience-container');
  const index = container.children.length;
  const wrapper = document.createElement('div');
  wrapper.classList.add('border','rounded','p-3','mb-3','bg-light','position-relative');
  wrapper.innerHTML = `
    <div class="row align-items-end">
      <div class="col-md-4 mb-3">
        <label class="form-label">Dairy Farm Name</label>
        <input type="text" name="company_name[]" class="form-control" placeholder="e.g. ABC Corp" required>
      </div>
      <div class="col-md-4 mb-3">
        <label class="form-label">Job Title</label>
        <input type="text" name="job_designation[]" class="form-control" placeholder="e.g. Software Engineer" required>
      </div>
      <div class="col-md-3 mb-3">
        <label class="form-label">Start Date</label>
        <input type="date" name="start_date[]" class="form-control" required>
      </div>
      <div class="col-md-3 mb-3">
        <label class="form-label">End Date <small class="text-muted">(optional)</small></label>
        <input type="date" name="end_date[]" class="form-control end-date">
        <div class="form-check mt-1">
          <input class="form-check-input present-checkbox" type="checkbox" id="present_${index}">
          <label class="form-check-label" for="present_${index}">Currently working here</label>
          <input type="hidden" name="is_present[]" value="0">
        </div>
      </div>
      <div class="col-md-6 mb-3">
        <label class="form-label">Key Responsibilities</label>
        <textarea name="work_responsibilities[]" class="form-control" rows="3" placeholder="Describe your role..." required></textarea>
      </div>
      <div class="col-md-2 mb-3 text-end">
        <button type="button" class="btn remove-btn" onclick="removeWorkExperience(this)">×</button>
      </div>
    </div>`;
  container.appendChild(wrapper);
}
function removeWorkExperience(btn){ btn.closest('.border').remove(); }
document.addEventListener("DOMContentLoaded", addWorkExperience);

// Handle "Currently working here" checkbox
document.addEventListener('change', function(e){
  if(e.target.classList.contains('present-checkbox')){
    const wrapper = e.target.closest('.row');
    const endDateField = wrapper.querySelector('.end-date');
    const hiddenField = wrapper.querySelector('input[name="is_present[]"]');

    if(e.target.checked){
      endDateField.readOnly = true;
      const today = new Date().toISOString().split('T')[0];
      endDateField.value = today;
      hiddenField.value = '1';
    } else {
      endDateField.readOnly = false;
      endDateField.value = '';
      hiddenField.value = '0';
    }
  }
});
</script>
<!-- CROP IMAGE MODAL -->
<div class="modal fade" id="cropImageModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Adjust & Crop Your Image</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <img id="imageToCrop" style="width:100%; max-height:500px;">
      </div>

      <div class="modal-footer">
        <button type="button" id="cropImageBtn" class="btn btn-primary">
            Crop & Upload
        </button>
      </div>

    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    let cropModal = document.getElementById("cropModal");
    let cropImage = document.getElementById("cropImage");
    let imageInput = document.getElementById("imageInput");
    let profilePreview = document.getElementById("profilePreview");
    let cropButton = document.getElementById("cropButton");
    let closeCrop = document.querySelector(".crop-close");

    let cropper;

    // When user selects image
    imageInput.addEventListener("change", function (e) {
        let file = e.target.files[0];
        if (!file) return;

        let reader = new FileReader();
        reader.onload = function (event) {
            cropImage.src = event.target.result;
            cropModal.style.display = "block";

            // Destroy previous cropper if exists
            if (cropper) {
                cropper.destroy();
            }

            // Initialize new CropperJS
            cropper = new Cropper(cropImage, {
                aspectRatio: 1,
                viewMode: 1,
                dragMode: "move",
                autoCropArea: 1,
                responsive: true,
                background: false
            });
        };
        reader.readAsDataURL(file);
    });

    // Crop & upload
    cropButton.addEventListener("click", function () {
        if (!cropper) return;

        let canvas = cropper.getCroppedCanvas({
            width: 300,
            height: 300
        });

        let croppedImageURL = canvas.toDataURL("image/png");

        // Update preview on page
        profilePreview.src = croppedImageURL;

        // Create hidden input for cropped Base64
        let hiddenInput = document.getElementById("profilePicCropped");
        if (!hiddenInput) {
            hiddenInput = document.createElement("input");
            hiddenInput.type = "hidden";
            hiddenInput.id = "profilePicCropped";
            hiddenInput.name = "profile_image";
            document.querySelector("form").appendChild(hiddenInput);
        }

        hiddenInput.value = croppedImageURL;

        cropModal.style.display = "none";
        cropper.destroy();
    });

    // Close Modal
    closeCrop.addEventListener("click", function () {
        cropModal.style.display = "none";
        if (cropper) cropper.destroy();
    });
});
</script>



<?php get_footer('custom'); ?>
</body>
</html>
