<?php
/**
 * Template Name: Download CV Template
 */

require_once get_template_directory() . '/dompdf/autoload.inc.php';
use Dompdf\Dompdf;

global $wpdb;

// Validate ?id=
if (!isset($_GET['id']) || empty($_GET['id'])) {
    wp_die("Invalid profile.");
}

$user_id = intval($_GET['id']);

// Fetch user profile
$profile = $wpdb->get_row($wpdb->prepare("
    SELECT p.*, u.username, u.email, u.contact
    FROM user_profiles p
    LEFT JOIN user_info u ON p.user_id = u.id
    WHERE p.user_id = %d
", $user_id));

if (!$profile) {
    wp_die("Profile not found.");
}

// Fetch education & experience
$education = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_education WHERE user_id = %d", $user_id));
$experience = $wpdb->get_results($wpdb->prepare("SELECT * FROM user_experience WHERE user_id = %d", $user_id));

// Profile Image Base64
$profile_image_base64 = '';
if (!empty($profile->image)) {
    $img_path = get_template_directory() . '/page-templates/uploads/' . $profile->image;
    if (file_exists($img_path)) {
        $img_type = pathinfo($img_path, PATHINFO_EXTENSION);
        $img_data = file_get_contents($img_path);
        $profile_image_base64 = 'data:image/' . $img_type . ';base64,' . base64_encode($img_data);
    }
}

// Build HTML
$html = '
<!DOCTYPE html>
<html>
<head>
<style>
    @page { margin: 0px; }
    body { font-family: Helvetica, Arial, sans-serif; margin: 0; padding: 0; }

    /* SPACING FOR ALL PAGES */
    .page-content { padding-top: 20px; } 
    .page-content:first-child { padding-top: 0 !important; }

   /* HEADER */
.header {
    width: 100%;
    background-color: #3c78b4;
    color: #fff;
    padding: 15px 25px;
}



    /* CONTENT */
    .section {
        padding: 0px 30px 0px 30px;
        page-break-inside: avoid;
        margin-bottom: 0px;
    }

    h2 {
        font-size: 18px;
        color: #fc3c68;
        border-bottom: 2px solid #fc3c68;
        margin-bottom: 10px;
        padding-bottom: 4px;
    }

    .list-item,p { 
        font-size: 13px; 
        margin-bottom: 10px; 
        line-height: 1.5;
    }

    /* FOOTER */
    .footer {
        position: fixed;
        bottom: 0;
        width: 100%;
        background-color: #3c78b4;
        color: #fff;
        text-align: center;
        padding: 10px 0;
        font-size: 11px;
    }
</style>
</head>

<body>

<div class="header">
<table width="100%" cellspacing="0" cellpadding="0">
<tr>
    <td width="80" valign="top">
        ' . ($profile_image_base64 ? '<img src="'.$profile_image_base64.'" style="width:100px;height:100px;border-radius:5%;object-fit:cover;">' : '') . '
    </td>

    <td valign="top" style="padding-left:7px; color:#fff;">
        <h1 style="margin:0; font-size:26px;">' . htmlspecialchars($profile->username) . '</h1>
        <p style="margin:0; font-size:12px;">' . htmlspecialchars($profile->email) . '</p>
        <p style="margin:0; font-size:12px;">' . htmlspecialchars($profile->contact) . '</p>
        <p style="margin:0; font-size:12px;">City: ' . htmlspecialchars($profile->city) . '</p>
        <p style="margin:0; font-size:12px;">Birthdate: ' . htmlspecialchars($profile->birthdate) . '</p>
    </td>
</tr>
</table>
</div>



<div class="page-content">

<div class="section">
    <h2>Bio</h2>
    <p >' . nl2br(htmlspecialchars($profile->bio)) . '</p>
</div>

<div class="section">
    <h2>Education</h2>';

foreach ($education as $edu) {
    $html .= '
        <div class="list-item">
            <strong>Degree:</strong> ' . htmlspecialchars($edu->course) . '<br>
            <strong>Institute:</strong> ' . htmlspecialchars($edu->institute) . '<br>
            <strong>Year:</strong> ' . htmlspecialchars($edu->completion_date) . '
        </div>';
}

$html .= '
</div>

<div class="section">
    <h2>Skills</h2>
    <p>' . nl2br(htmlspecialchars(str_replace(",", ", ", $profile->skills))) . '</p>

</div>

<div class="section">
    <h2>Experience</h2>';

foreach ($experience as $exp) {
    $html .= '
        <div class="list-item">
         <h4 style="margin:0px;padding:0px; font-size:16px;">' . htmlspecialchars($exp->job_designation) . '</h4>
            <strong>Company:</strong> ' . htmlspecialchars($exp->company_name) . '<br>
            <strong>Period:</strong> ' . htmlspecialchars($exp->start_date) . ' - ' . htmlspecialchars($exp->end_date ?: "Present") . '<br>
            <strong>Responsibilities:</strong><br> ' . nl2br(htmlspecialchars($exp->work_responsibilities)) . '
        </div>';
}

$html .= '
</div>

</div>

<div class="footer">Generated by Rumicare</div>

</body>
</html>
';

// Generate PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();
$dompdf->stream("CV-{$profile->username}.pdf", ["Attachment" => 1]);
exit;
?>
