<?php
/**
 * Template Name: Product Detail
 * Description: Displays full details of a single product.
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
get_header();

global $wpdb;
$table = 'rumicare_products';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$product = $wpdb->get_row("SELECT * FROM $table WHERE id = $id");
?>

<style>
.product-detail-container {
  width: 90%;
  margin: 50px auto;
  display: flex;
  flex-wrap: wrap;
  gap: 30px;
  font-family: "Red Hat Display", sans-serif;
  background: #fff;
  padding: 30px;
  border-radius: 12px;
  box-shadow: rgba(0,0,0,0.1) 0 4px 12px;
  /*align-items: center;*/
    
}

.product-detail-container img {
  width: 300px;
  height: 300px;
  /*object-fit: cover;*/
  object-fit: contain;
  border-radius: 10px;
  background: #f7f7f7;
  flex-shrink: 0;
}

.product-info {
  flex: 1;
  display: flex;
  flex-direction: column;
  justify-content: unset;
      text-align: left;
}

.product-info h2 {
  font-size: 20px;
  font-weight: 600;
  color: #222;
  margin-bottom: 5px;
}

.price {
  color: #007bff;
  font-size: 17px !important;
  font-weight: 700;
  margin-bottom: 20px;
}

/* ✅ Category and Seller side by side */
.meta-row {
  display: flex;
  justify-content: unset;
  align-items: center;
  gap: 15px;
  flex-wrap: wrap;
}

.meta-row p {
  font-size: 15px;
  color: #555;
  margin: 0;
}

.product-info p {
  font-size: 15px;
  color: #555;
  margin-bottom: 0px;
  
}

.back-btn {
    display: inline-block;
    margin-top: 25px;
    background: #007bff;
    color: #fff !important;
    padding: 6px 18px;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s;
    font-weight: 500;
    font-size: 10px;
    text-align: center;
    width: 50%;
}
.btn-whatsapp {
    display: inline-block;
    margin-top: 25px;
    background: green;
    color: #fff !important;
    padding: 6px 18px;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s;
    font-weight: 500;
    font-size: 10px;
    text-align: center;
    width: 50%;

}
.detail-sec{
    font-size:18px !important;
    margin-top:10px;
    font-weight:700;
}

.back-btn:hover {
  background: #0056b3;
}

@media (max-width: 768px) {
  .product-detail-container {
    flex-direction: column;
    align-items: left;
    text-align: left;
  }
  .product-detail-container img {
    width: 100%;
    height: 200px;
    object-fit: contain;
  }
  .meta-row {
    flex-direction: row;
    justify-content: left;
  }
  
      .product-detail-container img {
          border-top-left-radius: 15px !important;
        border-top-right-radius: 15px !important;
        border-bottom-left-radius: 0px !important;
            border-bottom-right-radius: 0px !important;
    
    }
    .product-detail-container {
      padding: 0px !important;
    }
    .product-info {
      padding: 0px 25px 20px 25px !important;
    }

}

.p_strong{
    line-height:23px;
}
p .strong {
    font-size: 15px;
    font-weight: 700;
    margin-top:10px;
}

.btn-div {
    display: flex;
    gap: 20px; /* adjust spacing between buttons */
    align-items: center; /* vertically center align */
}
</style>



<?php if ($product): 
  $image_path = get_template_directory_uri() . '/page-templates/Products-images/' . esc_attr($product->image);
?>
<div class="product-detail-container">
  <img src="<?php echo esc_url($image_path); ?>" alt="Product Image">

  <div class="product-info">
    <h2><?php echo esc_html($product->title); ?></h2>
    <p class="price">Rs <?php echo number_format($product->price, 2); ?></p>
  <p class="p_strong"><strong class="strong">Description: <br></strong><?php echo nl2br(esc_html($product->description)); ?></p>
  
  
    <!-- ✅ Category + Seller in single line -->
        <p class="detail-sec">Details</p>
      <p><strong>Category: </strong> <?php echo esc_html($product->category); ?></p>
      <p><strong>Seller: </strong> <?php echo esc_html($product->seller_name); ?></p>

  
<?php 
if ($product):
   $image_url = get_template_directory_uri() . '/page-templates/Products-images/' . $product->image;


    // Prepare product URL
$product_url = get_permalink() . '?id=' . $product->id;

    // Predefined WhatsApp message
    $whatsapp_message = "Hello, I want to buy this product.\n";
    $whatsapp_message .= "Product Name: " . $product->title . "\n";
    $whatsapp_message .= "Price: Rs " . number_format($product->price, 2) . "\n";
    $whatsapp_message .= "Product URL: " . $product_url;

    // Encode message for URL
    $whatsapp_message_url = urlencode($whatsapp_message);
    $whatsapp_message .= "Image: " . $image_path; // image link
?>
<div class="btn-div">
    <a class="btn-whatsapp" href="https://wa.me/+923357136958?text=<?php echo $whatsapp_message_url; ?>" target="_blank">
        Chat on Whatsapp
    </a>

    <!--<a href="javascript:history.back()" class="back-btn">Buy Online</a>-->

<a href="javascript:void(0)" class="back-btn open-order-popup">Buy Online</a>


</div>
<?php endif; ?>

  </div>
</div>

<?php else: ?>
  <p style="text-align:center; margin-top:80px;">❌ Product not found.</p>
<?php endif; ?>



<!-- Order Popup -->
<div class="order-popup-overlay" style="display:none;">
  <div class="order-popup-container">
    <span class="close-popup">×</span>
    <h2 class="popup-title">Place Your Order</h2>

    <form id="orderForm" method="post">
      <div class="form-group">
        <label>Full Name</label>
        <input type="text" name="name" placeholder="Enter your full name" required>
      </div>

      <div class="form-group">
        <label>Email Address</label>
        <input type="email" name="email" placeholder="Enter your email" required>
      </div>

      <div class="form-group">
        <label>Contact Number</label>
        <input type="tel" name="contact" placeholder="Enter your contact number" required>
      </div>

      <div class="form-group">
        <label>Delivery Address</label>
        <textarea name="address" placeholder="Enter delivery address" required></textarea>
      </div>

      <!-- Hidden product info -->
      <input type="hidden" name="product_id" value="<?php echo esc_attr($product->id); ?>">
      <input type="hidden" name="product_name" value="<?php echo esc_attr($product->title); ?>">
      <input type="hidden" name="price" value="<?php echo esc_attr($product->price); ?>">

      <button type="submit" class="btn-submit">Submit Order</button>
      <div id="orderResponse"></div>
    </form>
  </div>
</div>

<style>
/* Popup overlay */
.order-popup-overlay {
  position: fixed;
  top:0;
  left:0;
  width:100%;
  height:100%;
  background: rgba(0,0,0,0.6);
  display:flex;
  justify-content:center;
  align-items:center;
  z-index:9999;
}

/* Popup container */
.order-popup-container {
  background:#fff;
  padding:30px;
  width:400px;
  max-width:90%;
  border-radius:12px;
  position:relative;
  box-shadow:0 0 15px rgba(0,0,0,0.2);
  font-family:"League Spartan", sans-serif;
}

/* Close button */
.close-popup {
  position:absolute;
  top:15px;
  right:15px;
  font-size:22px;
  cursor:pointer;
}

/* Title */
.popup-title {
  font-size:22px;
  font-weight:700;
  margin-bottom:20px;
  text-align:center;
}

/* Form styles */
.order-popup-container .form-group {
  margin-bottom:15px;
}

.order-popup-container label {
  font-size:13px;
  font-weight:600;
  display:block;
  margin-bottom:5px;
}

.order-popup-container input,
.order-popup-container textarea {
  width:100%;
  padding:10px;
  font-size:15px;
  border-radius:6px;
  border:1px solid #ccc;
  box-sizing:border-box;
}

.order-popup-container textarea {
  resize:none;
  min-height:80px;
}

/* Submit button */
.btn-submit {
  background:#fc3c68;
  color:#fff;
  border:none;
  width:100%;
  padding:5px;
  font-size:16px;
  border-radius:8px;
  font-weight:600;
  cursor:pointer;
  transition: all 0.3s ease;
}

.btn-submit:hover {
  background:#e1325c;
}

/* Responsive */
@media screen and (max-width:500px){
  .order-popup-container {
    padding:20px;
  }
}
</style>

<script>
jQuery(function($){
  $('.open-order-popup').click(function(){
    $('.order-popup-overlay').fadeIn();
  });

  $('.close-popup').click(function(){
    $('.order-popup-overlay').fadeOut();
  });

  $('#orderForm').submit(function(e){
    e.preventDefault();

    // Collect form data
    const product_id   = $('input[name="product_id"]').val();
    const product_name = $('input[name="product_name"]').val();
    const price        = $('input[name="price"]').val();
    const name         = $('input[name="name"]').val();
    const email        = $('input[name="email"]').val();
    const contact      = $('input[name="contact"]').val();
    const address      = $('textarea[name="address"]').val();

    // Construct product URL dynamically
    const productUrl = window.location.origin + window.location.pathname + '?id=' + product_id;

    $.ajax({
      url: '/wp-content/themes/onum/order-submit.php',
      type: 'POST',
      data: $(this).serialize(),
      success: function(res){
        alert('✅ Order submitted successfully!');

        // Reset form and close popup
        $('#orderForm')[0].reset();
        $('.order-popup-overlay').fadeOut();

        // Send order details to WhatsApp
        let whatsappMessage = `Hello, I want to place an order.\n\n` +
                              `Name: ${name}\n` +
                              `Email: ${email}\n` +
                              `Contact: ${contact}\n` +
                              `Address: ${address}\n\n` +
                              `Product Name: ${product_name}\n` +
                              `Price: Rs ${price}\n` +
                              `Product ID: ${product_id}\n` +
                              `Product URL: ${productUrl}`;

        let whatsappUrl = 'https://wa.me/923357136958?text=' + encodeURIComponent(whatsappMessage);

        // Open WhatsApp in new tab
        window.open(whatsappUrl, '_blank');
      },
      error: function(){
        alert('❌ Submission failed. Please try again.');
      }
    });
  });
});

</script>


<!--abandoned orders-->
<script>
    jQuery(function($){
  
  function saveAbandonedOrder() {
    const data = {
      action: 'save_abandoned_order',
      product_id: $('input[name="product_id"]').val(),
      product_name: $('input[name="product_name"]').val(),
      price: $('input[name="price"]').val(),
      name: $('input[name="name"]').val(),
      email: $('input[name="email"]').val(),
      contact: $('input[name="contact"]').val(),
      address: $('textarea[name="address"]').val(),
    };

    $.post('<?php echo admin_url("admin-ajax.php"); ?>', data);
  }

  // Trigger save on typing or input change
  $('#orderForm input, #orderForm textarea').on('keyup change', function(){
    saveAbandonedOrder();
  });

});

</script>

<?php get_footer(); ?>
