<?php
/**
 * Handles product form submission
 */
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');
global $wpdb;

// Table name
$table_name = 'rumicare_products';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_product'])) {

    // Sanitize inputs
    $title             = sanitize_text_field($_POST['title']);
    $price             = floatval($_POST['price']);
    $shortdescription  = sanitize_textarea_field($_POST['short_description']);
    $description       = sanitize_textarea_field($_POST['description']);
    $category          = sanitize_text_field($_POST['category']);
    $seller_name       = sanitize_text_field($_POST['seller_name']);
    $quantity          = intval($_POST['quantity']);
    $created_at        = current_time('mysql');

    // Handle image upload
    $image_name = '';
    if (!empty($_FILES['product_image']['name'])) {

        $upload_dir = get_template_directory() . '/page-templates/Products-images/';

        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        $file_ext = pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION);
        $image_name = 'product_' . time() . '.' . $file_ext;
        $target_path = $upload_dir . $image_name;

        if (!move_uploaded_file($_FILES['product_image']['tmp_name'], $target_path)) {
            echo "<script>alert('❌ Image upload failed. Check folder permissions.');</script>";
            exit;
        }

    } else {
        echo "<script>alert('❌ No image selected.'); window.history.back();</script>";
        exit;
    }

    // Insert into DB
    $inserted = $wpdb->insert(
        $table_name,
        [
            'title'             => $title,
            'price'             => $price,
            'short_description' => $shortdescription,
            'description'       => $description,
            'category'          => $category,
            'seller_name'       => $seller_name,
            'quantity'          => $quantity,
            'image'             => $image_name,
            'created_at'        => $created_at
        ],
        [
            '%s', // title
            '%f', // price
            '%s', // short_description
            '%s', // description
            '%s', // category
            '%s', // seller_name
            '%d', // quantity
            '%s', // image
            '%s'  // created_at
        ]
    );

    if ($inserted) {
        echo "<script>
            alert('✅ Product uploaded successfully!');
            window.location.href = '" . esc_url(site_url('/super-admin-dashboard/')) . "';
        </script>";
    } else {
        echo "<script>
            alert('❌ Failed to upload product.');
            window.location.href = '" . esc_url(site_url('/product-upload/')) . "';
        </script>";
    }

} else {
    wp_redirect(home_url());
    exit;
}
?>
