<?php
/**
 * Template Name: Product Category
 */

get_header();
global $wpdb;

$cat_slug = isset($_GET['cat']) ? sanitize_text_field($_GET['cat']) : '';
if ($cat_slug) {

    $table = "rumicare_products";

    $products = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM $table WHERE category = %s", $cat_slug)
    );

    if ($products) {

        // UI/UX CSS
        echo '
        <style>
        
       h4 {
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            margin-top:40px;
        }

        .product-list {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(260px, 1fr));
            gap: 25px;
            padding: 20px 0px;
            width: 90%;
            max-width: 1300px;
            margin: 0 auto;
        }

        .product-link {
            text-decoration: none !important;
            color: inherit !important;
        }

        .product-item {
            background: #ffffff;
            border-radius: 14px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.10);
            transition: 0.3s;
            display: block; /* Desktop = vertical layout */
        }

        .product-item:hover {
            transform: translateY(-4px);
            box-shadow: 0 6px 18px rgba(0,0,0,0.15);
        }

        /* DESKTOP / LAPTOP */
        .product-image img {
            width: 100%;
            height: 220px;
            object-fit: cover;
            background: #f7f7f7;
        }

        .product-details {
            padding: 20px;
            text-align: center;
        }

        .product-details h3 {
            font-size: 22px;
            margin: 10px 0;
            color: #333;
            font-weight: 600;
        }

        .product-price {
            font-size: 18px;
            color: #fc3c68;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .product-details p {
            font-size: 13px;
            color: #555;
            margin: 0px;
        }
        
        .short_description{
            line-height:20px;
         margin-bottom: 10px !important;
        }

        /* MOBILE VIEW (IMAGE LEFT + DETAILS RIGHT) */
        @media (max-width: 768px) {

        .short_description{
            line-height:20px;
                    margin-bottom: 10px !important;
        }
            .product-list {
                grid-template-columns: 1fr; /* Only 1 item per row */
            }

            .product-item {
                display: flex; /* Side-by-side layout */
                flex-direction: row;
                align-items: center;
            }

            .product-image {
                width: 100%;
                height: auto;
                overflow: hidden;
            }

            .product-image img {
                // width: 100%;
                // height: 100%;
                object-fit: cover;
                // padding:20px
                
            }

            .product-details {
                width: 60%;
                text-align: left;
                padding: 15px;
            }

            .product-details h3 {
                font-size: 18px;
                margin-bottom: 5px;
            }

            .product-price {
                font-size: 16px;
            }
        }

.btn-sty{
   background: #cff1ff;
    padding: 3px 5px 2px 5px;
    font-size: 11px;
        color: #205f95;
    
}
        /* Global Font */
        // div, h1, h2, h3, h4, h5, h6, p, span {
        //     font-family: "League Spartan", Sans-serif !important;
        // }

        </style>
        ';
        
        echo '<h4>' . ucwords(str_replace('-', ' ', $cat_slug)) . '</h4>';


        echo '<div class="product-list">';

        foreach ($products as $p) {

            $product_id = $p->id;
            $detail_url = site_url('/product-detail/?id=' . $product_id);
            $image_url = get_stylesheet_directory_uri() . '/page-templates/Products-images/' . $p->image;

            echo '
            <a href="' . esc_url($detail_url) . '" class="product-link">
                <div class="product-item">

                    <div class="product-image">
                        <img src="' . esc_url($image_url) . '" alt="' . esc_html($p->title) . '">
                    </div>

                    <div class="product-details">
                        <h3>' . esc_html($p->title) . '</h3>
                        <p class="product-price">Rs ' . esc_html($p->price) . '</p>
                          <p class="short_description">' . esc_html($p->short_description) . '</p>
                        <p>Seller: ' . esc_html($p->seller_name) . '</p>
                        <a href="' . esc_url($detail_url) . '" class="btn-sty">View More</a>

                      
                    </div>

                </div>
            </a>';
        }

        echo '</div>';

    } else {
        echo '
<style>
.no-products-box {
    max-width: 90%;
    margin: 60px auto;
    padding: 35px 25px;
    background: #ffffff;
    border-radius: 14px;
    text-align: center;
    box-shadow: 0 4px 15px rgba(0,0,0,0.10);
}

.no-products-box img {
    width: 90px;
    opacity: 0.8;
    margin-bottom: 15px;
}

.no-products-box h3 {
    font-size: 22px;
    font-weight: 600;
    margin-bottom: 10px;
}

.no-products-box p {
    font-size: 15px;
    color: #555;
    margin-bottom: 20px;
}

.back-btn {
    display: inline-block;
    padding: 10px 22px;
    background: #fc3c68;
    color: #fff !important;
    border-radius: 8px;
    text-decoration: none !important;
    font-weight: 600;
    transition: 0.3s;
}

.back-btn:hover {
    background: #e02d57;
}
</style>

<div class="no-products-box">
    <img src="https://cdn-icons-png.flaticon.com/512/7486/7486754.png" alt="No Products">
    <h3>No Products Found</h3>
    <p>There are currently no items available in this category. Please explore other categories.</p>
    <a href="'.site_url('/rumicare-products/').'" class="back-btn">Browse Categories</a>
</div>
';

    }

} else {
    echo "<p style='padding:20px;'>No category selected.</p>";
}

get_footer();
?>
