<?php
/**
 * Template Name: Edit Blog
 */

session_start();

if (!isset($_SESSION['super_admin_id'])) {
    wp_redirect(home_url('/super-admin'));
    exit;
}

/* Auto-login for media */
if (!is_user_logged_in()) {
    $wp_user_id = 1; // admin/editor ID
    wp_set_current_user($wp_user_id);
    wp_set_auth_cookie($wp_user_id);
}

/* Get Post ID */
$post_id = isset($_GET['post_id']) ? intval($_GET['post_id']) : 0;
$post = get_post($post_id);

if (!$post || $post->post_type !== 'post') {
    wp_die('Invalid blog post');
}

$selected_categories = wp_get_post_categories($post_id);
$featured_image_id = get_post_thumbnail_id($post_id);

get_header();
?>
<style>
    input,
textarea,
select {
    font-size: 16px !important;
}
</style>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<div class="container py-5" style="max-width:900px">
    <div class="card">
        <h4 class="bg-dark text-white p-3 mb-0">Edit Blog</h4>

        <form method="post" enctype="multipart/form-data" class="p-4">

            <?php wp_nonce_field('edit_blog_nonce_action', 'edit_blog_nonce'); ?>
            <input type="hidden" name="post_id" value="<?= esc_attr($post_id) ?>">

            <!-- Title -->
            <div class="mb-3">
                <label>Blog Title</label>
                <input type="text"
                       name="blog_title"
                       class="form-control"
                       value="<?= esc_attr($post->post_title) ?>"
                       required>
            </div>

            <!-- Content -->
            <div class="mb-3">
                <label>Blog Content</label>
                <?php
                wp_editor($post->post_content, 'blog_content', [
                    'textarea_name' => 'blog_content',
                    'media_buttons' => true,
                    'textarea_rows' => 18
                ]);
                ?>
            </div>

            <!-- Categories -->
            <div class="mb-3">
                <label>Categories</label>
                <div class="border p-3 rounded">
                    <?php
                    $categories = get_categories(['hide_empty' => false]);
                    foreach ($categories as $cat) {
                        $checked = in_array($cat->term_id, $selected_categories) ? 'checked' : '';
                        echo "<label class='d-flex align-items-center gap-2'>
                            <input type='checkbox' name='blog_categories[]'
                                   value='{$cat->term_id}' $checked>
                            {$cat->name}
                        </label>";
                    }
                    ?>
                </div>
            </div>

            <!-- Featured Image -->
            <div class="mb-3">
                <label>Featured Image</label>

                <?php if ($featured_image_id): ?>
                    <div class="mb-2">
                        <?= wp_get_attachment_image($featured_image_id, 'medium'); ?>
                    </div>
                <?php endif; ?>

                <input type="file" name="featured_image" class="form-control">
            </div>

            <div class="d-flex gap-2">
                <button type="submit" name="update_blog" class="btn btn-success">
                    Update Blog
                </button>

                <a href="<?= site_url('/super-admin-dashboard') ?>"
                   class="btn btn-secondary">Back</a>
            </div>

        </form>
    </div>
</div>




<?php get_footer(); ?>
