<?php
/**
 * Template Name: Online-Farm Training
 */
get_header();

global $wpdb;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['online_farm_submit'])) {

    $table_name = 'wp_online_farm_traning_applications';

    // Common fields (always outside Farm/Vet forms)
    $apply_as       = sanitize_text_field($_POST['apply_as'] ?? '');
    $candidate_name = sanitize_text_field($_POST['candidate_name'] ?? '');
    $whatsapp       = sanitize_text_field($_POST['whatsapp_no'] ?? '');
    $email          = sanitize_email($_POST['email'] ?? '');

    // Default values for NOT NULL fields
    $farm_name     = '';
    $total_anim    = 0;
    $training_on   = '';

    $degree_name     = '';
    $completion_year = '';
    $address         = '';
    $city            = '';

    // Farm-specific fields
    if ($apply_as === 'farm') {
        $farm_name   = sanitize_text_field($_POST['farm_name'] ?? '');
        $total_anim  = intval($_POST['total_animals'] ?? 0);
        $training_on = sanitize_text_field($_POST['training_on'] ?? '');
    }

    // Vet-specific fields
    if ($apply_as === 'vet') {
        $degree_name     = sanitize_text_field($_POST['degree_name'] ?? '');
        $completion_year = sanitize_text_field($_POST['completion_year'] ?? '');
        $address         = sanitize_text_field($_POST['address'] ?? '');
        $city            = sanitize_text_field($_POST['city'] ?? '');
    }

    // Email duplicate check
    if (!empty($email)) {
        $exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE email = %s", $email));
        if ($exists > 0) {
            echo "<script>alert('❌ You have already applied. Our team will contact you soon.'); window.location.href = window.location.href;</script>";
            exit;
        }
    }

    // Insert into database
    $inserted = $wpdb->insert(
        $table_name,
        [
            'apply_as'        => $apply_as,
            'candidate_name'  => $candidate_name,
            'whatsapp_no'     => $whatsapp,
            'email'           => $email,
            'farm_name'       => $farm_name,
            'total_animals'   => $total_anim,
            'training_on'     => $training_on,
            'degree_name'     => $degree_name,
            'completion_year' => $completion_year,
            'address'         => $address,
            'city'            => $city,
            'applied_on'      => current_time('mysql'),
        ]
    );

    if ($inserted) {
        echo "<script>alert('✅ Application submitted successfully!'); window.location.href = window.location.href;</script>";
        exit;
    } else {
        echo '<div style="color:red;padding:10px;border:1px solid red;border-radius:6px;margin:10px 0;">❌ Error: ' . esc_html($wpdb->last_error) . '</div>';
    }
}
?>


<div class="group-farm-container">
  <h2>Online-Farm Training Application Form</h2>

  <form method="POST" class="group-farm-form">


    <!-- Radio Buttons -->
    <div class="apply-as-row">
  <label>Apply As <span>*</span></label>
  <div class="radio-inline">
    <label><input type="radio" name="apply_as" value="farm" checked> Farmer</label>
    <label><input type="radio" name="apply_as" value="vet"> Vet Doctor</label>
  </div>
</div>

    <!-- Candidate Name -->
    <label>Name of Candidate <span>*</span></label>
    <input type="text" name="candidate_name" required>
    
     <label>WhatsApp Number <span>*</span></label>
    <input type="text" name="whatsapp_no" required>

    <label>Email (Optional)</label>
    <input type="email" name="email">


    <!-- ====================== FARM FORM (DEFAULT) ====================== -->
    <div id="farm_form">

      <div class="form-row">
        <div class="form-group">
          <label>Farm Name <span>*</span></label>
          <input type="text" name="farm_name">
        </div>

        <div class="form-group">
          <label>Total Animals <span>*</span></label>
          <input type="number" name="total_animals">
        </div>
      </div>
    </div>

        <div class="form-row">
             <div class="form-group">
               <label>City <span>*</span></label>
               <input type="text" name="city">
            </div>
            
            <div class="form-group">
                <label>Address <span>*</span></label>
               <input type="text" name="address">
            </div>
        </div>


    <!-- ====================== VET DOCTOR FORM ====================== -->
    <div id="vet_form" style="display:none;">

    
     <div class="form-row">
            <div class="form-group">
                <label>Degree Name <span>*</span></label>
              <input type="text" name="degree_name">
            </div>
    
            <div class="form-group">
             <label>Completion Year <span>*</span></label>
               <input type="date" name="completion_year">
            </div>
          </div>
      
     
         

    </div>
    
          <label>Which Type of Training you want <span>*</span></label>
             <select name="training_on">
                <option value="">Select Training Type</option>
                <option value="Nutrition & TMR">Nutrition & TMR</option>
                <option value="Health & Breeding">Health & Breeding</option>
                <option value="Hoof trimming & General Management">Hoof trimming & General Management</option>
             </select>   

    <button type="submit" name="online_farm_submit">Submit Application</button>
  </form>
</div>

<style>

.group-farm-container {
  width: 90%;
  max-width: 600px;
  margin: 40px auto;
  background: #fff;
  padding: 25px 30px;
  border-radius: 10px;
  box-shadow: rgba(0, 0, 0, 0.1) 0 4px 10px;
  font-family: "League Spartan", Sans-serif;
}

.group-farm-container h2 {
  text-align: center;
  margin-bottom: 20px;
  font-weight: 600;
  color: #333;
  font-size: 2rem;
}

.group-farm-form label {
  /*display: block;*/
  margin-top: 12px;
  font-weight: 500;
  color: #444;
  font-size: 16px;
}


.group-farm-form input{
      padding: 5px;

}
.group-farm-form input,
.group-farm-form select,
.group-farm-form textarea {
  width: 100%;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 16px !important;
  box-sizing: border-box;
  background: white;
}



.group-farm-form select,
.group-farm-form textarea {
  padding: 10px;
}

/* ✅ Always keep two fields in one line */
.group-farm-form .form-row {
  display: flex;
  justify-content: space-between;
  gap: 10px;
  flex-wrap: nowrap; /* prevents stacking */
}

.group-farm-form .form-row .form-group {
  width: 50%;
}


.radio-group {
  display: flex;
  gap: 20px;
  margin-top: 5px;
}

.group-farm-form input[type="date"] , select{
  height: 40px;
  padding: 10px 12px;
  width: 90%;
}

select{
  padding: 10px 12px;
}

.group-farm-form button {
  width: 100%;
  margin-top: 20px;
  padding: 10px;
  background: #007bff;
  border: none;
  color: #fff;
  border-radius: 6px;
  font-weight: 600;
  cursor: pointer;
  transition: background 0.3s;
  font-size: 1.1rem;
}


.group-farm-form button:hover {
  background: #0056b3;
}

.group-farm-form span {
  color: red;
}


.apply-as-row {
  display: flex;
  align-items: center;
  gap: 15px; /* reduce gap for iPhone */
  margin-top: 15px;
  margin-bottom:15px;
  flex-wrap: wrap; /* prevent overflow on small screens */
}

.apply-as-row > label {
  margin-top: 12px;
  font-weight: 500;
  color: #444;
  font-size: 16px;
}

.radio-inline {
  display: flex;
  gap: 20px; /* adjust spacing */
  align-items: center;
  flex-wrap: wrap; /* ensures labels wrap on small screens */
}

/* Style radio buttons for iOS/Android consistently */
.radio-inline label {
  display: flex;
  align-items: center;
  gap: 8px; /* spacing between button and text */
  font-size: 14px;
  cursor: pointer;
  user-select: none;
}

/* Reset default radio buttons */
input[type="radio"] {
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  width: 20px; /* slightly larger for better tap */
  height: 20px;
  border: 2px solid #007bff;
  border-radius: 50%;
  outline: none;
  position: relative;
  margin: 0;
}

/* Checked state */
input[type="radio"]:checked::before {
  content: '';
  width: 12px;
  height: 12px;
  background: #007bff;
  border-radius: 50%;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}




/* Responsive tweaks */
@media (max-width: 400px) {
  .apply-as-row {
    gap: 10px;
  }
  .radio-inline {
    gap: 15px;
  }
}
</style>



<script>
document.addEventListener("DOMContentLoaded", function() {

    const farmForm = document.getElementById("farm_form");
    const vetForm = document.getElementById("vet_form");

    document.querySelectorAll("input[name='apply_as']").forEach(radio => {
        radio.addEventListener("change", function () {
            if (this.value === "farm") {
                farmForm.style.display = "block";
                vetForm.style.display = "none";
            } else {
                farmForm.style.display = "none";
                vetForm.style.display = "block";
            }
        });
    });

});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const farmForm = document.getElementById("farm_form");
    const vetForm  = document.getElementById("vet_form");

    function toggleRequired(activeForm, inactiveForm) {
        activeForm.querySelectorAll("input, select").forEach(el => {
            if (el.hasAttribute("data-required")) {
                el.setAttribute("required", "required");
            }
        });

        inactiveForm.querySelectorAll("input, select").forEach(el => {
            el.removeAttribute("required");
        });
    }

    // Mark required fields safely
    document.querySelectorAll("input[required], select[required]").forEach(el => {
        el.setAttribute("data-required", "true");
    });

    document.querySelectorAll("input[name='apply_as']").forEach(radio => {
        radio.addEventListener("change", function () {
            if (this.value === "farm") {
                farmForm.style.display = "block";
                vetForm.style.display = "none";
                toggleRequired(farmForm, vetForm);
            } else {
                farmForm.style.display = "none";
                vetForm.style.display = "block";
                toggleRequired(vetForm, farmForm);
            }
        });
    });

    // Run once on page load
    toggleRequired(farmForm, vetForm);

});
</script>



<?php get_footer(); ?>
