<?php
/**
 * Template Name: User Login Template
 * Description: Login for normal users and farm owners with separate redirects.
 */

get_header();
global $wpdb;

session_start(); // Start PHP session

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_input = sanitize_text_field($_POST['login']);
    $password    = $_POST['password'];

    $user_type = ''; // to track type
    $user_id   = 0;  // to store ID for redirect
    $user_name = '';

    // --- Check normal users ---
    $user = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM user_info WHERE username = %s OR email = %s LIMIT 1",
        $login_input,
        $login_input
    ));

    if ($user) {
        $user_type = 'user';
        $user_id   = $user->id;
        $user_name = $user->username;
    }

    // --- If not found, check farm owners ---
    if (!$user) {
        $farm = $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM farmers_info WHERE full_name = %s OR email = %s LIMIT 1",
            $login_input,
            $login_input
        ));

        if ($farm) {
            $user_type = 'farm';
            $user_id   = $farm->id;
            $user_name = $farm->full_name;
        }
    }

    // --- Verify password ---
    $hashed_password = $user->password ?? $farm->password ?? '';
    if ($user_type && password_verify($password, $hashed_password)) {

        // Store login info in PHP session
        session_regenerate_id(true); // Prevent session fixation
        $_SESSION['user_id']   = $user_id;
        $_SESSION['username']  = $user_name;
        $_SESSION['user_type'] = $user_type;

        // Prepare redirect URL
        if ($user_type === 'user') {
            $redirect_url = home_url("/user-detail-page/?id={$user_id}");
        } else {
            $redirect_url = home_url("/farm-dashboard/?id={$user_id}");
        }

        // Redirect safely using PHP
        wp_safe_redirect($redirect_url);
        exit;

    } else {
        $message = '<div class="alert alert-danger mt-3">❌ Incorrect login or password. Please try again.</div>';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>User Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


<style>
body { background-color: #f7f7f7; font-family: "League Spartan", sans-serif; }
.login-container { max-width: 420px; margin: 80px auto; background: #fff; padding: 35px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
.btn-login { background-color: #fc3c68; color: #fff; font-weight: 600; border-radius: 8px; transition: all 0.3s ease;font-size:15px; }
.btn-login:hover { background-color: #e1325c; transform: translateY(-2px); }

.mb-4 {
    margin-bottom: 3.5rem !important;
    font-size: 22px !important;
}
label {
    font-size: 13px;
}
.text-end {
    font-size: 12px;
}
.text-center {
    font-size: 13px;
}
.btn.btn-outline-primary {
    font-size: 12px;
    
} 
input{
        padding: 10px 10px !important;
         font-size: 16px !important;
    border-radius: 5px !important;

    }

.btn-sty {
    display: flex;
    justify-content: space-evenly;
}

@media screen and (max-width: 600px) {
 .login-container { max-width: 90%;}

}
</style>
</head>
<body>

<div class="login-container">
  <h2 class="text-center mb-4">User Login</h2>
  <?php echo $message; ?>
  <form method="post" action="">
    <div class="mb-3">
      <label class="form-label">Email or Full Name</label>
      <input type="text" name="login" class="form-control" placeholder="Enter your email or full name" required>
    </div>
    
<div class="mb-3 position-relative">
  <label class="form-label">Password</label>
  <div class="input-group">
    <input type="password" name="password" id="passwordField" class="form-control" placeholder="Enter your password" required>
    <button type="button" class="btn btn-outline-secondary" id="togglePassword" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
      <i class="fa-solid fa-eye" id="eyeIcon"></i>
    </button>
  </div>
</div>

    <div class="d-grid">
      <button type="submit" class="btn btn-login py-2">Login</button>
    </div>
  </form>
  
  
  <div class="text-end mt-2">
  <a href="https://rumicare.bibigadgets.com/forgot-password/" class="text-decoration-none">
    Forgot Password?
  </a>
</div>

   
    <div class="text-center mt-4">
      <p>Don't have an account?</p>
      <div class="btn-sty">
      <a href="https://rumicare.bibigadgets.com/farm-singup-page/" class="btn btn-outline-primary">Create Farmar Account</a>
        <a href="https://rumicare.bibigadgets.com/user-signup/" class="btn btn-outline-primary">Create User Account</a>
    </div>
</div>
</div>
</div>



</body>
</html>

<?php get_footer('custom'); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const passwordField = document.getElementById('passwordField');
  const togglePassword = document.getElementById('togglePassword');
  const eyeIcon = document.getElementById('eyeIcon');

  togglePassword.addEventListener('click', function() {
    const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
    passwordField.setAttribute('type', type);
    eyeIcon.classList.toggle('fa-eye');
    eyeIcon.classList.toggle('fa-eye-slash');
  });
});
</script>