<?php
/**
 *
 * Template Name: Singup Farm Page
 * Description: A Page Template with a design.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ONUM
 */

get_header();
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Professional User Registration Form</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Bootstrap 5 JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

<!-- Include Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


  <style>
    body { background-color: #f8f9fa; }

    .form-section {
      background: #ffffff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      margin-bottom: 30px;
      margin-left:15px;
      margin-right:15px;
    }

    .form-control { border-radius: 3px !important; }

    .form-heading {
      font-weight: bold;
      font-size:18px;
      margin-bottom: 20px;
      border-bottom: 2px solid #dee2e6;
      padding-bottom: 5px;
      color:red;
    }

    .form-headingg {
      font-weight: bold;
      font-size:15px;
      color:red;
    }

    .remove-btn { background-color: #dc3545; color: white; }
    .add-btn { background-color: #198754; color: white; }
    
    .head-text,span,div{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:13px;
    }
    
    input,textarea,label{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:16px;
    }
     input{
        padding: 10px 10px !important;
         font-size: 16px !important;
          border-radius: 5px;
    }
     .head-texttt{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:18px;
    }
      .head-texttt1{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:13px;
         font-style: italic;

    }
    .head-para{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 400;
        color: #000000;
        font-size:15px;
    }
    .main-sec {
      width: 90%;
      margin: auto;
      padding: 20px 15px 0px 15px;
    }
 
    .text-endd{   
      width: 90%;
      margin: auto;
    }
    .text-endd button {
      width: 100%;
      font-size: 16px;
      padding-top: 6px;
    }
    
     .add-btn {
  background-color: #198754;
  color: white;
  margin-left: auto;   /* pushes button to right */
  display: block;      /* make sure it respects auto margins */
}

.text-end {
    margin-bottom: 15px !important;
}
  </style>
</head>
<body>
    
<div class="main-sec">
   <div class="d-flex justify-content-between align-items-center">
      <div class="left-text">
        <span class="head-texttt">Singup First to Post a Job</span><br>
         <span class="head-texttt1">(Fillout the form for getting the best employ)</span><br>
      </div>
      <div class="right-icon">
        <img style="height:50px;width:50px" src="<?php echo get_template_directory_uri(); ?>/page-templates/43wedsde.png" alt="Icon">
      </div>
   </div>
</div>

<div class="container my-5">
      
      <form action="<?php echo esc_url( get_template_directory_uri() . '/page-templates/farm-singup-submit.php' ); ?>" method="POST" enctype="multipart/form-data">


    <!-- Section: Personal Info -->
    <div class="form-section">
      <div class="form-heading">Create Account</div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Full Name</label>
          <input type="text" name="username" class="form-control" placeholder="Enter your full name" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Email (optional)</label>
          <input type="email" name="email" class="form-control" placeholder="example@example.com">
        </div>
    
        <div class="col-md-6 mb-3">
          <label class="form-label">WhatsApp No</label>
          <input type="tel" name="contact" class="form-control" placeholder="+92 300 456 3445" required>
        </div>
        
          <div class="col-md-6 mb-3">
           <label class="form-label">Password</label>
              <div class="input-group">
                <input type="password" name="password" id="passwordField" class="form-control" placeholder="Enter your password" required>
                <button type="button" class="btn btn-outline-secondary" id="togglePassword" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
                  <i class="fa-solid fa-eye" id="eyeIcon"></i>
                </button>
              </div>

        </div>
        
      </div>
    </div>


    <!-- Submit Button -->
    <div class="text-endd">
      <button type="submit" class="btn btn-primary px-4">Submit</button>
    </div>

  </form>
</div>

</body>



<?php get_footer(); ?>


<script>
document.addEventListener('DOMContentLoaded', function() {
  const passwordField = document.getElementById('passwordField');
  const togglePassword = document.getElementById('togglePassword');
  const eyeIcon = document.getElementById('eyeIcon');

  togglePassword.addEventListener('click', function() {
    const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
    passwordField.setAttribute('type', type);
    eyeIcon.classList.toggle('fa-eye');
    eyeIcon.classList.toggle('fa-eye-slash');
  });
});
</script>