<?php
/**
 *
 * Template Name: Farm Job Posting Form
 * Description: A Page Template with a design.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ONUM
 */

get_header();
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Professional User Registration Form</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Bootstrap 5 JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <link href="https://fonts.googleapis.com/css2?family=League+Spartan:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    body { background-color: #f8f9fa; }

    .form-section {
      background: #ffffff;
      padding: 25px;
      border-radius: 12px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      margin-bottom: 30px;
      margin-left:15px;
      margin-right:15px;
    }

    .form-control { border-radius: 3px !important; }

    .form-heading {
      font-weight: bold;
      font-size:15px;
      margin-bottom: 20px;
      border-bottom: 2px solid #dee2e6;
      padding-bottom: 5px;
      color:red;
    }

    .form-headingg {
      font-weight: bold;
      font-size:15px;
      color:red;
    }

    .remove-btn { background-color: #dc3545; color: white; }
    .add-btn { background-color: #198754; color: white;}
    
    .head-text,span,div{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:13px;
    }
    
    input, textarea, select{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:16px !important;
    }
    
    label{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:15px;
    }
    
     .head-texttt{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:16px;
    }
      .head-texttt1{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 600;
        color: #000000;
        font-size:13px;
         font-style: italic;

    }
    .head-para{
        font-family: "League Spartan", Sans-serif !important;
        font-weight: 400;
        color: #000000;
        font-size:13px;
    }
    .main-sec {
      width: 90%;
      margin: auto;
      padding: 20px 15px 0px 15px;
    }
 
    .text-endd{   
      width: 90%;
      margin: auto;
    }
    .text-endd button {
      width: 100%;
      font-size: 16px;
      padding-top: 6px;
    }
    
    .add-btn {
      background-color: #198754;
      color: white;
      margin-left: auto;   /* pushes button to right */
      display: block;      /* make sure it respects auto margins */
}

.text-end {
    margin-bottom: 15px !important;
}
select.form-select {
    padding: 9px 20px;
}
  </style>
</head>
<body>
    
<div class="main-sec">
   <div class="d-flex justify-content-between align-items-center">
      <div class="left-text">
        <span class="head-texttt">Post a Job</span><br>
         <span class="head-texttt1">(Fillout the form for getting the best employ)</span><br>
      </div>
      <div class="right-icon">
        <img style="height:50px;width:50px" src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/Farm-Profile-pic-2.png" alt="Icon">
      </div>
   </div>
</div>

<div class="container my-5">
      
      <form action="<?php echo esc_url( get_template_directory_uri() . '/page-templates/farm-job-submit.php' ); ?>" method="POST" enctype="multipart/form-data">

    <!-- Section: Job Role -->
    <div class="form-section">
      <div class="form-heading">Are You Looking For a</div>

   <div class="mb-3">
  <label class="form-label d-block">Select Role</label>
  <select class="form-select" name="role" required>

    <!-- Group 1 -->
    <option disabled style="color:red">Veterinary & Farm Management</option>
    <option value="Veterinary Doctor (DVM)">Veterinary Doctor (DVM)</option>
    <option value="Veterinary Doctor & Farm Manager">Veterinary Doctor & Farm Manager</option>
    <option value="Veterinary Assistant (VA)">Veterinary Assistant (VA)</option>
    <option value="Artificial Insemination Technician (AIT)">Artificial Insemination Technician (AIT)</option>
    <option value="Dairy Farm Consultant">Dairy Farm Consultant</option>
    <option value="Dairy Nutritionist">Dairy Nutritionist</option>
    <option value="Dairy Farm Supervisor">Dairy Farm Supervisor</option>

    <!-- Group 2 -->
    <option disabled style="color:red">Farm Operations</option>
    <option value="Milkers">Milkers</option>
    <option value="Tractor Drivers">Tractor Drivers</option>
    <option value="Data Entry Operator">Data Entry Operator</option>
    <option value="Dairy Accountant">Dairy Accountant</option>

  </select>
</div>


      <div class="mb-3">
        <label class="form-label">Minimum Experience (Years)</label>
        <input type="text" name="experience" class="form-control" placeholder="e.g. 2 Years">
      </div>

     <div class="mb-3">
  <label class="form-label">Key Requirements</label>
  <textarea name="key_requirments" class="form-control" rows="6"
    placeholder="Example:
Requirement 1,
Requirement 2,
Requirement 3"></textarea>
</div>

    </div>


    <!-- Section: Dairy Farm Information -->
    <div class="form-section">
      <div class="form-heading">Dairy Farm Information</div>

      <div class="row">
        <div class="col-md-6 mb-3">
          <label class="form-label">Dairy Farm Name</label>
          <input type="text" name="farm_name" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Total Animals</label>
          <input type="number" name="total_animals" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Milking Cows</label>
          <input type="number" name="milking_cows" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">Address</label>
          <input type="text" name="address" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
          <label class="form-label">City</label>
          <input type="text" name="city" class="form-control" required>
        </div>
        <div class="col-12 mb-3">
          <label class="form-label">More About Dairy Farm (optional)</label>
          <textarea name="farm_about" class="form-control" rows="6"></textarea>
        </div>
      </div>
    </div>

    <!-- Section: Salary & Benefits -->
    <div class="form-section">
      <div class="form-heading">Salary Package & Other Benefits</div>

               <div class="mb-3">
                          <label class="form-label d-block">Salary Package</label>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="30,000 - 50,000" required>
                            <label class="form-check-label">30,000 - 50,000</label>
                          </div>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="50,000 - 100,000">
                            <label class="form-check-label">50,000 - 100,000</label>
                          </div>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="100,000 - 150,000">
                            <label class="form-check-label">100,000 - 150,000</label>
                          </div>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="150,000 - 250,000">
                            <label class="form-check-label">150,000 - 250,000</label>
                          </div>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="250,000 - 350,000">
                            <label class="form-check-label">250,000 - 350,000</label>
                          </div>
                        
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="salary" value="Above 350,000">
                            <label class="form-check-label">Above 350,000</label>
                          </div>
            
            </div>


      <div class="mb-3">
        <label class="form-label d-block">Other Benefits</label>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="benefits[]" value="Meal & Residency"> <label class="form-check-label">Meal & Residency</label></div>
        <div class="form-check"><input class="form-check-input" type="checkbox" name="benefits[]" value="Bonus on Performance Base"> <label class="form-check-label">Bonus on Performance Base</label></div>
      </div>
      
          <div class="mb-3">
              <label class="form-label d-block">Post a Job</label>
            
              <div class="form-check">
                <input class="form-check-input" type="radio" name="job_visibility" value="public" required>
                <label class="form-check-label">Publicly</label>
                <span style="margin-left:6px; font-size:14px;font-weight:400;">(If you want to display this job publicly)</span>
              </div>
            
              <div class="form-check">
                <input class="form-check-input" type="radio" name="job_visibility" value="confidential">
                <label class="form-check-label">Confidential</label>
                <span style="margin-left:6px; font-size:14px;font-weight:400;">(If you want to keep this job private)</span>
              </div>
        </div>


    </div>

    <!-- Submit Button -->
    <div class="text-endd">
      <button type="submit" class="btn btn-primary px-4">Submit Job</button>
    </div>

  </form>
</div>

</body>


<?php get_footer('custom'); ?>
</html>
