<?php
/**
 * Template Name: Add Blog
 */

session_start();

/* Super admin check */
if (!isset($_SESSION['super_admin_id'])) {
    wp_redirect(home_url('/super-admin'));
    exit;
}

/**
 * Auto-login WordPress user
 * Required for media upload
 */
if (!is_user_logged_in()) {
    $wp_user_id = 1; // CHANGE to your Admin / Editor user ID
    wp_set_current_user($wp_user_id);
    wp_set_auth_cookie($wp_user_id);
}

get_header();
?>

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #f5f6fa;
    font-family: Poppins, sans-serif;
}
.container {
    max-width: 900px;
    /*padding: 50px 20px;*/
}

.box-container{
     padding: 50px 20px;
}
.card {
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}
.category-box label {
    display: flex;
    align-items: center;
    gap: 8px;
    cursor: pointer;
}
.card-body {
    padding: 0;
}
.card-body form {
    padding: 20px;
}
.title-sty {
    background: #000;
    padding: 15px;
    color: #fff;
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
}

input,
textarea,
select {
    font-size: 16px !important;
}

</style>

<div class="container box-container">
    <div class="card">
        <div class="card-body">

            <h4 class="title-sty mb-0">Add New Blog</h4>

            <form method="post" enctype="multipart/form-data">

                <?php wp_nonce_field('add_blog_nonce_action', 'add_blog_nonce'); ?>

                <!-- Blog Title -->
                <div class="mb-3">
                    <label class="form-label">Blog Title</label>
                    <input type="text" name="blog_title" class="form-control" required>
                </div>

                <!-- Blog Content -->
                <div class="mb-3">
                    <label class="form-label">Blog Content</label>

                    <?php
                    if (function_exists('wp_enqueue_editor')) {
                        wp_enqueue_editor();
                    }

                    wp_editor('', 'blog_content', [
                        'textarea_name' => 'blog_content',
                        'media_buttons' => true,
                        'textarea_rows' => 18,
                        'teeny'         => false,
                        'quicktags'     => true,
                        'tinymce'       => true,
                    ]);
                    ?>
                </div>

                <!-- Categories -->
                <div class="mb-3">
                    <label class="form-label">Select Categories</label>
                    <div class="category-box border rounded p-3">
                        <?php
                        $categories = get_categories(['hide_empty' => false]);
                        foreach ($categories as $cat) {
                            echo '<label>
                                    <input type="checkbox" name="blog_categories[]" value="' . esc_attr($cat->term_id) . '">
                                    ' . esc_html($cat->name) . '
                                  </label>';
                        }
                        ?>
                    </div>
                </div>

                <!-- Featured Image -->
                <div class="mb-4">
                    <label class="form-label">Featured Image</label>
                    <input type="file" name="featured_image" class="form-control" accept="image/*">
                </div>

                <!-- Buttons -->
                <div class="d-flex gap-2">
                    <button type="submit" name="submit_blog" class="btn btn-primary">
                        Publish Blog
                    </button>

                    <a href="<?= esc_url(site_url('/super-admin-dashboard')) ?>" class="btn btn-secondary">
                        Back
                    </a>
                </div>

            </form>

        </div>
    </div>
</div>

<?php get_footer(); ?>
