<?php
/**
 * Custom Footer Template
 */
session_start(); // Start session to check login
?>

<style>
footer.custom-footer {
    background-color: #ffffff;
    padding: 15px 0;
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    z-index: 9999;
    box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
}

.custom-footer .flex-wrap {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 38px;
    flex-wrap: wrap;
}

.custom-footer .flex-wrap a img {
    height: 25px;
    width: auto;
}

/*a#footer-user-icon img.user-logged-img {*/
/*    border-radius: 700px !important;*/
/*    width: 35px;*/
/*    height: 35px;*/
/*}*/

body { padding-bottom: 70px; }

.user-menu {
    position: fixed;
    bottom: -200px;
    left: 0;
    width: 100%;
    background: #fff;
    box-shadow: 0 -5px 15px rgba(0,0,0,0.2);
    border-top-left-radius: 20px;
    border-top-right-radius: 20px;
    transition: bottom 0.4s ease;
    text-align: center;
    z-index: 9999;
    padding: 10px 0;
}

.user-menu.active { bottom: 0; }

.user-menu ul {
    list-style: none;
    margin: 0;
    padding: 0;
}

.user-menu ul li {
    padding: 12px 0;
    border-bottom: 1px solid #eee;
}

.user-menu ul li:last-child { border-bottom: none; }

.user-menu ul li a {
    text-decoration: none;
    color: #333 !important;
    font-weight: 600;
    display: block;
    font-size: 14px;
}




</style>

<?php
session_start();
global $wpdb;

// === Default icon for everyone initially ===
$default_icon = 'https://rumicare.bibigadgets.com/wp-content/uploads/2025/09/erfsdxc.svg';
$user_image = "$default_icon";
$user_profile_link = home_url('/user-login-form/'); // Default profile link for guests

// === Check if user is logged in ===
if (isset($_SESSION['user_id'])) {
    $user_id = intval($_SESSION['user_id']);
    $user_type = $_SESSION['user_type'] ?? 'user';

    // === Check if user is a farmer ===
    if ($user_type === 'farm') {
        // Farmer always sees the default image
        $user_image = "https://rumicare.bibigadgets.com/wp-content/uploads/2025/12/3ersfd.png";
        $user_profile_link = home_url('/farm-dashboard/');
    } else {
        // Regular user - check if they have a profile image
        $user = $wpdb->get_row(
            $wpdb->prepare("SELECT image FROM user_profiles WHERE user_id = %d", $user_id)
        );

        if ($user && !empty($user->image)) {
            // ✅ User has uploaded a profile image
            $user_image = esc_url('https://rumicare.bibigadgets.com/wp-content/themes/onum/page-templates/uploads/' . $user->image);
        }

        // ✅ User profile link
        $user_profile_link = home_url('/user-detail-page/?id=' . $user_id);
    }
}

// === Apply CSS only if profile image exists ===
// ✅ Apply circular CSS only when custom image is shown
if (isset($_SESSION['user_id']) && isset($user) && !empty($user->image) && $_SESSION['user_type'] !== 'farm') {
    echo '<style>
        a#footer-user-icon img.user-logged-img {
            border-radius: 700px !important;
            width: 35px;
            height: 35px;
            object-fit: cover;
        }
    </style>';
}
?>

<footer class="custom-footer">
    <div class="container">
        <div class="flex-wrap">
            <a href="<?php echo home_url('/'); ?>">
                <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/09/45tedfx.svg" alt="Home Icon">
            </a>
            
            <a href="#" target="_blank"> <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/09/45dfr.svg" alt="Icon 2"> </a> <a href="#" target="_blank"> <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/09/35erfsx.svg" alt="Icon 3"> </a>
            
            <a href="#" target="_blank"> <img src="https://rumicare.bibigadgets.com/wp-content/uploads/2025/09/34rwfsdse.svg" alt="Icon 4"> </a>
            
            
<!-- ✅ Footer User Icon -->
<a id="footer-user-icon" href="<?php echo esc_url($user_profile_link); ?>">
    <img id="footer-user-img"
         class="user-logged-img"
         src="<?php echo esc_url($user_image); ?>"
         alt="User Icon">
</a>



            <!-- Hidden Popup Menu -->
            <div id="user-menu" class="user-menu">
                <ul id="user-menu-list">
    <?php
    if (isset($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];
        $user_type = $_SESSION['user_type'] ?? 'user';

        if ($user_type === 'farm') {
            // Farmer Menu
            echo '<li><a href="' . home_url('/farm-dashboard/') . '">Dashboard</a></li>';
            echo '<li><a href="' . home_url('/farma-form/') . '">Job Post</a></li>';
            echo '<li><a href="' . home_url('?logout=1') . '" id="logout-btn">Logout</a></li>';
        } else {
            // Regular user menu
            $profile_url = home_url('/user-detail-page/?id=' . intval($user_id));

            echo '<li><a href="' . esc_url($profile_url) . '">Profile</a></li>';
            echo '<li><a href="' . home_url('/tranning-pagess/') . '">Apply for a Job</a></li>';
            echo '<li><a href="' . home_url('?logout=1') . '" id="logout-btn">Logout</a></li>';
        }
    } else {
        // Guest Menu
        echo '<li><a href="' . home_url('/user-login-form/') . '">Login</a></li>';
    }
    ?>
</ul>

            </div>
        </div>
    </div>
</footer>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const icon = document.getElementById('footer-user-icon');
    const menu = document.getElementById('user-menu');

    // Toggle menu
    icon.addEventListener('click', function(e) {
        e.preventDefault();
        menu.classList.toggle('active');
    });

    // Close if clicked outside
    document.addEventListener('click', function(e) {
        if (!menu.contains(e.target) && !icon.contains(e.target)) {
            menu.classList.remove('active');
        }
    });
});
</script>
<?php
session_start();

// ✅ Logout handling MUST be BEFORE any HTML
if (isset($_GET['logout']) && $_GET['logout'] == 1) {
    session_unset();
    session_destroy();
    echo '<script>
    
    alert("✅ Logout Successfully!");
    window.location.href = "' . home_url('/') . '";</script>';
    exit;
}
?>

<?php wp_footer(); ?>
